<?php

/**
 * Load Theme Dependencies
 */
require_once get_theme_file_path('/core/class/theme-dependencies.php');

/**
 * Sequence of theme specific actions
 */

add_action('after_setup_theme', function() {
    $content_width = $content_width ?? 940;
}, 0);

add_action('after_setup_theme', function() {
    add_theme_support('title-tag');
	add_theme_support( 'html5', [
		'gallery',
		'caption',
	]);
});

add_action('init', function() {
    add_post_type_support('page', 'excerpt');
});

/** Add a pingback url auto-discovery for single posts, pages or attachments. */
add_action('wp_head', function() {
    if (is_singular() && pings_open()) {
        echo '<link rel="pingback" href="', esc_url(get_bloginfo('pingback_url')), '">';
    }
});

add_action( 'current_screen', function() {
    add_editor_style( 'css/font-awesome-5.min.css' );
} );

add_action( 'wgl/preloader', 'WGL_Framework::preloader' );

add_action( 'wgl/after_main_content', 'bili_after_main_content' );

/**
 * Sequence of theme specific filters
 */

add_filter( 'wgl/header/enable', 'bili_header_enable' );

add_filter( 'wgl/page_title/enable', 'bili_page_title_enable' );

add_filter( 'wgl/footer/enable', 'bili_footer_enable' );

add_filter( 'comment_form_fields', 'bili_comment_form_fields' );

add_filter('mce_buttons_2', function($buttons) {
	array_unshift($buttons, 'styleselect');
    return $buttons;
});

add_filter('tiny_mce_before_init', 'bili_tiny_mce_before_init');

add_filter('wp_list_categories', 'bili_categories_postcount_filter');
add_filter('woocommerce_layered_nav_term_html', 'bili_categories_postcount_filter');

add_filter('get_archives_link', 'bili_render_archive_widgets', 10, 6);

add_filter('wgl/enqueue_shortcode_css', function( $styles ) {
    global $bili_dynamic_css;
    if ( ! isset( $bili_dynamic_css[ 'style' ] ) ) {
        $bili_dynamic_css = [];
        $bili_dynamic_css['style'] = $styles;
    } else {
        $bili_dynamic_css['style'] .= $styles;
    }
});

add_filter('widget_types_to_hide_from_legacy_widget_block', function () {
    return [];
}, 10);
