<?php
/**
 * This template can be overridden by copying it to `yourtheme[-child]/bili-core/elementor/templates/wgl-countdown.php`.
 */
namespace WGL_Extensions\Templates;

defined('ABSPATH') || exit; // Abort, if called directly.

/**
 * WGL Elementor Countdown Template
 *
 *
 * @author WebGeniusLab <webgeniuslab@gmail.com>
 * @since 1.0.0
 */
class WGLCountDown
{
	private static $instance ;

	public static function get_instance()
	{
		if (is_null(self::$instance)) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function render($self, $atts)
	{
		extract($atts);

		wp_enqueue_script(
			'jquery-countdown',
			get_template_directory_uri() . '/js/jquery.countdown.min.js',
			[],
			false,
			false
		);

		// Module unique id
		$cd_attr = ' id=' . uniqid("countdown_");

		$cd_class = $show_separating ? ' has-dots' : '';

		$f = ! $hide_day ? 'd' : '';
		$f .= ! $hide_hours ? 'H' : '';
		$f .= ! $hide_minutes ? 'M' : '';
		$f .= ! $hide_seconds ? 'S' : '';

		// Countdown data attribute http://keith-wood.name/countdown.html
		$data['format'] = !empty($f) ? esc_attr($f) : '';

		$data['year'] = esc_attr($countdown_year);
		$data['month'] = esc_attr($countdown_month);
		$data['day'] = esc_attr($countdown_day);
		$data['hours'] = esc_attr($countdown_hours);
		$data['minutes'] = esc_attr($countdown_min);

		$data['labels'][]  = esc_html__('Years', 'bili-core');
		$data['labels'][]  = esc_html__('Months', 'bili-core');
		$data['labels'][]  = esc_html__('Weeks', 'bili-core');
		$data['labels'][]  = esc_html__('Days', 'bili-core');
		$data['labels'][]  = esc_html__('Hours', 'bili-core');
		$data['labels'][]  = esc_html__('Minutes', 'bili-core');
		$data['labels'][]  = esc_html__('Seconds', 'bili-core');
		$data['labels1'][] = esc_html__('Year', 'bili-core');
		$data['labels1'][] = esc_html__('Month', 'bili-core');
		$data['labels1'][] = esc_html__('Week', 'bili-core');
		$data['labels1'][] = esc_html__('Day', 'bili-core');
		$data['labels1'][] = esc_html__('Hour', 'bili-core');
		$data['labels1'][] = esc_html__('Minute', 'bili-core');
		$data['labels1'][] = esc_html__('Second', 'bili-core');

		$attrs = json_encode($data, true);
		$output = '<div'.$cd_attr.' class="wgl-countdown'.esc_attr($cd_class).'" data-atts="'.esc_js($attrs).'"></div>';
		echo \WGL_Framework::render_html($output);

	}

}