<?php
/**
 * This template can be overridden by copying it to `bili[-child]/bili-core/elementor/widgets/wgl-button-widget.php`.
 */
namespace WGL_Extensions\Widgets;

defined( 'ABSPATH' ) || exit; // Abort, if called directly.

use Elementor\{
    Widget_Base,
    Controls_Manager,
    Group_Control_Border,
    Group_Control_Typography,
    Group_Control_Box_Shadow
};
use WGL_Extensions\{
    WGL_Framework_Global_Variables as WGL_Globals,
	Includes\WGL_Icons,
	Templates\WGL_Button,
    Includes\WGL_Cursor
};

class WGL_Button_widget extends Widget_Base
{
    public function get_name()
    {
        return 'wgl-button';
    }

    public function get_title()
    {
        return esc_html__( 'WGL Button', 'bili-core' );
    }

    public function get_icon()
    {
        return 'wgl-button';
    }

    public function get_categories()
    {
        return [ 'wgl-modules' ];
    }

    protected function register_controls()
    {
        /** CONTENT -> GENERAL */

        $this->start_controls_section(
            'content_general',
            [ 'label' => esc_html__( 'General', 'bili-core' ) ]
        );

        $this->add_control(
            'text',
            [
                'label' => esc_html__( 'Text', 'bili-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [ 'active' => true ],
	            'label_block' => true,
                'placeholder' => esc_attr__( 'ex: MORE SERVICES', 'bili-core' ),
                'default' => esc_html__( 'MORE SERVICES', 'bili-core' ),
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => esc_html__( 'Link', 'bili-core' ),
                'type' => Controls_Manager::URL,
                'placeholder' => esc_attr__( 'https://your-link.com', 'bili-core' ),
                'default' => [ 'url' => '#' ],
            ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label' => esc_html__( 'Alignment', 'bili-core' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bili-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bili-core' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bili-core' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Full Width', 'bili-core' ),
                        'icon' => 'eicon-h-align-stretch',
                    ],
                ],
                'default' => 'left',
                'prefix_class' => 'a%s',
            ]
        );

        $this->add_control(
            'size',
            [
                'label' => esc_html__( 'Size', 'bili-core' ),
                'type' => Controls_Manager::SELECT,
                'style_transfer' => true,
                'options' => [
                    'xl' => esc_html__( 'Extra Large', 'bili-core' ),
                    'lg' => esc_html__( 'Large', 'bili-core' ),
                    'md' => esc_html__( 'Medium', 'bili-core' ),
                    'sm' => esc_html__( 'Small', 'bili-core' ),
                ],
                'default' => 'lg',
            ]
        );

        $this->end_controls_section();

        $extra_controls[ 'icon_align' ] = [
            'label' => esc_html__( 'Position', 'bili-core' ),
            'type' => Controls_Manager::SELECT,
            'condition' => [ 'icon_type!' => '' ],
            'options' => [
                'left' => esc_html__( 'Before', 'bili-core' ),
                'right' => esc_html__( 'After', 'bili-core' ),
            ],
            'default' => 'right',
        ];

        $extra_controls[ 'icon_indent' ] = [
            'label' => esc_html__( 'Offset', 'bili-core' ),
            'type' => Controls_Manager::SLIDER,
            'condition' => [ 'icon_type!' => '' ],
            'range' => [
                'px' => [ 'max' => 50 ],
            ],
            'selectors' => [
                '{{WRAPPER}} .media-wrapper' => '--media-offset: {{SIZE}}{{UNIT}};',
            ],
        ];

        $extra_controls[ 'icon_visibility' ] = [
            'label' => esc_html__( 'Visibility', 'bili-core' ),
            'type' => Controls_Manager::SELECT,
            'condition' => [ 'icon_type' => 'font' ],
            'options' => [
                '' => esc_html__( 'Always', 'bili-core' ),
                'hover' => esc_html__( 'On Hover', 'bili-core' ),
            ],
            'prefix_class' => 'icon-visibility-'
        ];

        WGL_Icons::init(
            $this,
            [
                'output' => $extra_controls,
                'section' => true,
            ]
        );

        /**
         * GENERAL -> CURSOR
         */

        WGL_Cursor::init(
            $this,
            [
                'section' => true,
            ]
        );

        /** STYLE -> GENERAl */

        $this->start_controls_section(
            'style_general',
            [
                'label' => esc_html__( 'General', 'bili-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .wgl-button',
            ]
        );

        $this->add_responsive_control(
            'button_min_width',
            [
                'label' => esc_html__( 'Min Width', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'range' => [
                    'px' => [ 'max' => 230 ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'min-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_min_height',
            [
                'label' => esc_html__( 'Min Height', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'range' => [
                    'px' => [ 'max' => 230 ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'min-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'fields_options' => [
                    'width' => [ 'label' => esc_html__( 'Border Width', 'bili-core' ) ],
                    'color' => [ 'type' => Controls_Manager::HIDDEN ],
                ],
                'selector' => '{{WRAPPER}} .wgl-button',
            ]
        );

        $this->add_responsive_control(
            'button_radius',
            [
                'label' => esc_html__( 'Border Radius', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_animation',
            [
                'label' => esc_html__( 'Use Animated Background', 'bili-core' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'animated-bg',
                'prefix_class' => 'has-',
                'default' => 'animated-bg',
                'selectors' => [
                    '{{WRAPPER}} .wgl-button::after' => 'content: "";',
                ],
            ]
        );

        $this->start_controls_tabs( 'button' );

        $this->start_controls_tab(
            'button_idle',
            [ 'label' => esc_html__( 'Idle', 'bili-core' ) ]
        );

        $this->add_control(
            'button_color_idle',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'default' => WGL_Globals::get_btn_color_idle(),
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_border_color_idle',
            [
                'label' => esc_html__( 'Border Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [ 'border_border!' => '' ],
                'dynamic' => [ 'active' => true ],
                'default' => WGL_Globals::get_btn_bg_idle(),
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_idle',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'default' => WGL_Globals::get_btn_bg_idle(),
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'background-color: {{VALUE}};',

                    '{{WRAPPER}}.has-animated-bg .wgl-button::after' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}}.has-animated-bg .wgl-button' => 'background-color: transparent !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_bg_top_offset_idle',
            [
                'label' => esc_html__( 'Background Top Offset', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'condition' => [ 'button_bg_animation!' => '' ],
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [ 'min' => -200, 'max' => 200 ],
                    '%' => ['min' => -100,'max' => 100],
                ],
                'default' => [ 'size' => 0 ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button::after' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_bg_left_offset_idle',
            [
                'label' => esc_html__( 'Background Left Offset', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'condition' => [ 'button_bg_animation!' => '' ],
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [ 'min' => -200, 'max' => 200 ],
                    '%' => ['min' => -100,'max' => 100],
                ],
                'default' => [ 'size' => 0 ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button::after' => 'left:{{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_bg_size',
            [
                'label' => esc_html__('Background Size', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'condition' => [ 'button_bg_animation!' => '' ],
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'default' => [
                    'size' => 60,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button::after' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ]
            ]
        );

        $this->add_control(
            'button_bg_border_radius',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [ 'button_bg_animation!' => '' ],
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                    'unit' => '%',
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_shadow_idle',
                'selector' => '{{WRAPPER}} .wgl-button',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_hover',
            [ 'label' => esc_html__( 'Hover', 'bili-core' ) ]
        );

        $this->add_control(
            'button_color_hover',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'default' => WGL_Globals::get_btn_color_hover(),
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:hover,
                     {{WRAPPER}} .wgl-button:focus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_hover',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'default' => WGL_Globals::get_btn_bg_idle(),
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:hover,
                     {{WRAPPER}} .wgl-button:focus' => 'background-color: {{VALUE}};',

                    '{{WRAPPER}}.has-animated-bg .wgl-button:hover::after,
                     {{WRAPPER}}.has-animated-bg .wgl-button:focus::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_border_color_hover',
            [
                'label' => esc_html__( 'Border Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [ 'border_border!' => '' ],
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:hover,
                     {{WRAPPER}} .wgl-button:focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_bg_top_offset_hover',
            [
                'label' => esc_html__( 'Background Top Offset', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'condition' => [ 'button_bg_animation!' => '' ],
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [ 'min' => -200, 'max' => 200 ],
                    '%' => ['min' => -100,'max' => 100],
                ],
                'default' => [ 'size' => 0 ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:hover::after' => 'top:  {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_bg_left_offset_hover',
            [
                'label' => esc_html__( 'Background Left Offset', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'condition' => [ 'button_bg_animation!' => '' ],
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [ 'min' => -200, 'max' => 200 ],
                    '%' => ['min' => -100,'max' => 100],
                ],
                'default' => [ 'size' => 0 ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:hover::after' => 'left:  {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_bg_size_hover',
            [
                'label' => esc_html__('Background Size', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'condition' => [ 'button_bg_animation!' => '' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 2000,
                    ],
                    '%' => [
						'min' => 0,
						'max' => 100,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'default' => [
                    'size' => 100,
                    'unit' => '%',
                ],
                'tablet_default' => [
                    'size' => 100,
                    'unit' => '%',
                ],
                'mobile_default' => [
                    'size' => 100,
                    'unit' => '%',
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:hover::after' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
                'render_type' => 'template',
            ]
        );

        $this->add_control(
            'button_bg_border_radius_hover',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [ 'button_bg_animation!' => '' ],
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => 32,
                    'right' => 32,
                    'bottom' => 32,
                    'left' => 32,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:hover::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_shadow_hover',
                'selector' => '{{WRAPPER}} .wgl-button:hover'
                            . '{{WRAPPER}} .wgl-button:focus',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_active',
            [ 'label' => esc_html__( 'Active', 'bili-core' ) ]
        );

        $this->add_control(
            'button_color_active',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_active',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:active' => 'background-color: {{VALUE}};',

                    '{{WRAPPER}}.has-animated-bg .wgl-button:active::after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_border_color_active',
            [
                'label' => esc_html__( 'Border Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [ 'border_border!' => '' ],
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:active' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_bg_top_offset_active',
            [
                'label' => esc_html__( 'Background Top Offset', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'condition' => [ 'button_bg_animation!' => '' ],
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [ 'min' => -200, 'max' => 200 ],
                    '%' => ['min' => -100,'max' => 100],
                ],
                'default' => [ 'size' => 0 ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:active::after' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_bg_left_offset_active',
            [
                'label' => esc_html__( 'Background Left Offset', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'condition' => [ 'button_bg_animation!' => '' ],
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [ 'min' => -200, 'max' => 200 ],
                    '%' => ['min' => -100,'max' => 100],
                ],
                'default' => [ 'size' => 0 ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:active::after' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_bg_size_active',
            [
                'label' => esc_html__('Background Size', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'condition' => [ 'button_bg_animation!' => '' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 2000,
                    ],
                    '%' => [
						'min' => 0,
						'max' => 100,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'default' => [
                    'size' => 100,
                    'unit' => '%',
                ],
                'tablet_default' => [
                    'size' => 100,
                    'unit' => '%',
                ],
                'mobile_default' => [
                    'size' => 100,
                    'unit' => '%',
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:active::after' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
                'render_type' => 'template',
            ]
        );

        $this->add_control(
            'button_bg_border_radius_active',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [ 'button_bg_animation!' => '' ],
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => 32,
                    'right' => 32,
                    'bottom' => 32,
                    'left' => 32,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:active::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_shadow_active',
                'selector' => '{{WRAPPER}} .wgl-button:active',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /** STYLE -> MEDIA */

        $this->start_controls_section(
            'style_media',
            [
                'label' => esc_html__( 'Media (icon/image)', 'bili-core' ),
                'condition' => [ 'icon_type!' => '' ],
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

	    $this->add_responsive_control(
		    'image_max_width',
		    [
			    'label' => esc_html__( 'Max Width', 'bili-core' ),
			    'type' => Controls_Manager::SLIDER,
			    'condition' => [ 'icon_type' => 'image' ],
			    'size_units' => [ 'px', '%' ],
			    'range' => [
				    'px' => [ 'min' => 0, 'max' => 768 ],
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-image-box_img img' => 'max-width: {{SIZE}}{{UNIT}};',
			    ],
		    ]
	    );

        $this->add_responsive_control(
            'media_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [ 'icon_type' => 'image' ],
                'size_units' => [ 'px', 'em', '%', 'vw' ],
                'selectors' => [
                    '{{WRAPPER}} .media-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_size',
            [
                'label' => esc_html__( 'Icon Size', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'condition' => [ 'icon_type' => 'font' ],
                'size_units' => [ 'px', 'em', 'rem', 'vw' ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-icon' => '--icon-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_rotation',
            [
                'label' => esc_html__( 'Rotation', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'condition' => [ 'icon_type' => 'font' ],
                'size_units' => [ 'deg', 'turn' ],
                'range' => [
                    'px' => [ 'max' => 360 ],
                ],
                'default' => [ 'unit' => 'deg' ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-icon' => 'transform: rotate({{SIZE}}{{UNIT}});',
                ],
            ]
        );

        $this->start_controls_tabs(
            'tabs_icon',
            [
                'condition' => [ 'icon_type' => 'font' ],
                'separator' => 'before',
            ]
        );

        $this->start_controls_tab(
            'icon_idle',
            [ 'label' => esc_html__( 'Idle', 'bili-core' ) ]
        );

        $this->add_control(
            'icon_color_idle',
            [
                'label' => esc_html__( 'Icon Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'default' => WGL_Globals::get_btn_color_idle(),
                'selectors' => [
                    '{{WRAPPER}} .elementor-icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'icon_hover',
            [ 'label' => esc_html__( 'Hover', 'bili-core' ) ]
        );

        $this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__( 'Icon Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:hover .elementor-icon,
                     {{WRAPPER}} .wgl-button:focus .elementor-icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'icon_active',
            [ 'label' => esc_html__( 'Active', 'bili-core' ) ]
        );

        $this->add_control(
            'icon_color_active',
            [
                'label' => esc_html__( 'Icon Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:active .elementor-icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /** STYLE -> ANIMATION */

        $this->start_controls_section(
            'style_animation',
            [
                'label' => esc_html__( 'Animation', 'bili-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'hover_animation',
            [
                'label' => esc_html__( 'Hover State Animation', 'bili-core' ),
                'type' => Controls_Manager::HOVER_ANIMATION,
            ]
        );

        $this->add_control(
            'highlight_animation',
            [
                'label' => esc_html__( 'Use Highlight Animation', 'bili-core' ),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

		$this->add_control(
			'stroke_highlight_color_normal',
			[
				'label' => esc_html__( 'Stroke Color', 'bili-core' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
                'condition' => [ 'highlight_animation' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .highlight_svg path' => 'stroke: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
            'stroke_highlight_width_normal',
            [
                'label' => esc_html__( 'Stroke Width', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'vw' ],
                'condition' => [ 'highlight_animation' => 'yes' ],
                'range' => [
                    'px' => [ 'min' => 0.1, 'max' => 10 ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .highlight_svg path' => 'stroke-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        ( new WGL_Button() )->render(
            $this,
            $this->get_settings_for_display()
        );
    }

    public function wpml_support_module()
    {
        add_filter( 'wpml_elementor_widgets_to_translate', [ $this, 'wpml_widgets_to_translate_filter' ] );
    }

    public function wpml_widgets_to_translate_filter( $widgets )
    {
        return \WGL_Extensions\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }
}
