<?php
/**
 * This template can be overridden by copying it to `bili[-child]/bili-core/elementor/widgets/wgl-cases.php`.
 */
namespace WGL_Extensions\Widgets;

defined('ABSPATH') || exit; // Abort, if called directly.

use Elementor\{Group_Control_Image_Size,
	Group_Control_Typography,
	Icons_Manager,
	Widget_Base,
	Controls_Manager,
	Control_Media,
	Group_Control_Border,
	Group_Control_Box_Shadow,
	Group_Control_Background,
	Repeater,
	Utils};
use WGL_Extensions\Includes\{
    WGL_Carousel_Settings,
	WGL_Icons
};
use WGL_Extensions\WGL_Framework_Global_Variables as WGL_Globals;

class WGL_Cases extends Widget_Base
{
    public function get_name()
    {
        return 'wgl-cases';
    }

    public function get_title()
    {
        return esc_html__('WGL Cases', 'bili-core');
    }

    public function get_icon()
    {
        return 'wgl-services-2';
    }

    public function get_script_depends()
    {
        return ['swiper'];
    }

    public function get_categories()
    {
        return ['wgl-modules'];
    }

    protected function register_controls()
    {
        /**
         * CONTENT -> GENERAL
         */

        $this->start_controls_section(
            'section_content_general',
            ['label' => esc_html__('General', 'bili-core')]
        );

	    $this->add_responsive_control(
		    'item_grid',
		    [
			    'label' => esc_html__('Grid Columns Amount', 'bili-core'),
			    'type' => Controls_Manager::SLIDER,
			    'range' => [
				    'px' => ['min' => 1, 'max' => 6 ],
			    ],
			    'size_units' => ['px'],
			    'default' => ['size' => 3],
			    'tablet_default' => ['size' => 2],
			    'mobile_default' => ['size' => 1],
			    'selectors' => [
				    '{{WRAPPER}} .case_items' => 'width: calc(100% / {{SIZE}});',
			    ],
			    'label_block' => true,
		    ]
	    );

	    $this->add_control(
		    'item_grid_refresh',
		    [
			    'type' => Controls_Manager::HIDDEN,
			    'condition' => ['use_carousel!' => ''],
			    'render_type' => 'template',
		    ]
	    );

	    $repeater = new Repeater();

	    WGL_Icons::init(
		    $repeater,
		    [
			    'section' => false,
			    'default' => [
				    'media_type' => 'image',
				    'url' => Utils::get_placeholder_image_src(),
			    ],
			    'media_types_options' => [
				    '' => [
					    'title' => esc_html__('None', 'bili-core'),
					    'icon' => 'fa fa-ban',
				    ],
				    'image' => [
					    'title' => esc_html__('Image', 'bili-core'),
					    'icon' => 'far fa-image',
				    ],
			    ],
		    ]
	    );

	    $repeater->add_responsive_control(
		    'thumbnail_width',
		    [
			    'label' => esc_html__('Image Width', 'bili-core'),
			    'type' => Controls_Manager::SLIDER,
			    'range' => [
				    'px' => ['min' => 10, 'max' => 500 ],
				    '%' => ['min' => 10, 'max' => 100 ],
			    ],
			    'size_units' => ['px', '%'],
			    'selectors' => [
				    '{{WRAPPER}} {{CURRENT_ITEM}}.case_items img' => 'width: {{SIZE}}{{UNIT}};',
			    ],
			    'label_block' => true,
		    ]
	    );

	    $repeater->add_control(
		    'title',
		    [
			    'label' => esc_html__('Title', 'bili-core'),
			    'type' => Controls_Manager::TEXT,
			    'separator' => 'before',
			    'dynamic' => [ 'active' => true ],
			    'label_block' => true,
			    'placeholder' => esc_attr_x( 'ex: MORE', 'WGL Cases', 'bili-core' ),
			    'default' => esc_html_x( 'MORE', 'WGL Cases', 'bili-core' ),
		    ]
	    );

	    $repeater->add_control(
		    'link',
		    [
			    'label' => esc_html__('Add Link', 'bili-core'),
			    'type' => Controls_Manager::URL,
			    'label_block' => true,
			    'separator' => 'before',
			    'placeholder' => esc_attr__( 'https://your-link.com', 'bili-core' ),
			    'default' => [ 'url' => '#' ],
		    ]
	    );

	    $repeater->add_control(
		    'add_read_more',
		    [
			    'label' => esc_html__('\'Read More\' Button', 'bili-core'),
			    'type' => Controls_Manager::SWITCHER,
			    'label_on' => esc_html__('Use', 'bili-core'),
			    'label_off' => esc_html__('Hide', 'bili-core'),
			    'default' => 'yes'
		    ]
	    );

	    $repeater->add_control(
		    'read_more_text',
		    [
			    'label' => esc_html__('Button Text', 'bili-core'),
			    'type' => Controls_Manager::TEXT,
			    'dynamic' => [ 'active' => true ],
			    'label_block' => true,
			    'condition' => [ 'add_read_more!' => '' ],
			    'placeholder' => esc_attr_x( 'ex: Website for Agency', 'WGL Cases', 'bili-core' ),
		    ]
	    );

	    $repeater->add_control(
		    'read_more_icon_fontawesome',
		    [
			    'label' => esc_html__('Button Icon', 'bili-core'),
			    'type' => Controls_Manager::ICONS,
			    'condition' => [ 'add_read_more' => 'yes' ],
			    'description' => esc_html__('Select icon from available libraries.', 'bili-core'),
			    'label_block' => true,
			    'default' => [
				    'value' => 'flaticon flaticon-plus',
				    'library' => 'flaticon',
			    ],
		    ]
	    );

        $this->add_control(
            'list',
            [
                'label' => esc_html__('Items', 'bili-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => esc_html__('MORE', 'bili-core'),
                        'read_more_text' => esc_html__('Website for Agency', 'bili-core'),
                        'read_more_icon_fontawesome' => [
                            'value' => 'flaticon flaticon-plus',
                            'library' => 'flaticon',
                        ],
                    ],
                    [
                        'title' => esc_html__('MORE', 'bili-core'),
                        'read_more_text' => esc_html__('Development Software', 'bili-core'),
                        'read_more_icon_fontawesome' => [
                            'value' => 'flaticon flaticon-plus',
                            'library' => 'flaticon',
                        ],
                    ],
                    [
                        'title' => esc_html__('MORE', 'bili-core'),
                        'read_more_text' => esc_html__('Technology Process', 'bili-core'),
                        'read_more_icon_fontawesome' => [
                            'value' => 'flaticon flaticon-plus',
                            'library' => 'flaticon',
                        ],
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

	    $this->add_responsive_control(
		    'alignment',
		    [
			    'label' => esc_html__('Alignment', 'bili-core'),
			    'type' => Controls_Manager::CHOOSE,
			    'toggle' => true,
			    'options' => [
				    'flex-start' => [
					    'title' => esc_html__('Left', 'bili-core'),
					    'icon' => 'eicon-text-align-left',
				    ],
				    'center' => [
					    'title' => esc_html__('Center', 'bili-core'),
					    'icon' => 'eicon-text-align-center',
				    ],
				    'flex-end' => [
					    'title' => esc_html__('Right', 'bili-core'),
					    'icon' => 'eicon-text-align-right',
				    ],
			    ],
			    'default' => 'center',
			    'selectors' => [
				    '{{WRAPPER}} .case_items__inner_wrapper' => 'align-items: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'module_link',
		    [
			    'label' => esc_html__('Whole Module Link', 'bili-core'),
			    'type' => Controls_Manager::SWITCHER,
		    ]
	    );

	    $this->add_control(
		    'chess_layout',
		    [
			    'label' => esc_html__('Chess Layout', 'bili-core'),
			    'type' => Controls_Manager::SWITCHER,
			    'separator' => 'before',
			    'return_value' => 'chess',
			    'prefix_class' => 'layout-',
		    ]
	    );

	    $this->add_control(
		    'chess_layout_invert',
		    [
			    'label' => esc_html__('Invert Chess Layout', 'bili-core'),
			    'type' => Controls_Manager::SWITCHER,
			    'condition' => ['chess_layout!' => ''],
			    'return_value' => 'chess',
			    'prefix_class' => 'invert-',
		    ]
	    );

	    $this->add_responsive_control(
		    'chess_offset',
		    [
			    'label' => esc_html__('Chess Offset', 'bili-core'),
			    'type' => Controls_Manager::SLIDER,
			    'condition' => ['chess_layout!' => ''],
			    'size_units' => ['px', 'rem'],
			    'range' => [
				    'px' => ['min' => 1, 'max' => 300],
				    'rem' => ['min' => 0.1, 'max' => 20, 'step' => 0.1],
			    ],
			    'default' => ['size' => 60],
			    'tablet_default' => ['size' => 30],
			    'mobile_default' => ['size' => 0],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-cases' => 'padding-top: {{SIZE}}{{UNIT}} !important;',
				    '{{WRAPPER}}:not(.invert-chess) .case_items:nth-child(even)' => 'margin-top: -{{SIZE}}{{UNIT}};',
				    '{{WRAPPER}}.invert-chess .case_items:nth-child(odd)' => 'margin-top: -{{SIZE}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'chess_notice',
		    [
			    'type' => Controls_Manager::RAW_HTML,
			    'condition' => [ 'chess_layout!' => '' ],
			    'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
			    'raw' => esc_html__('Note: even number of Case Items is preffered.', 'bili-core'),
		    ]
	    );

	    $this->end_controls_section();

        /**
         * CONTENT -> CAROUSEL OPTIONS
         */

        WGL_Carousel_Settings::add_controls($this);

        /**
         * STYLES -> ITEMS
         */

        $this->start_controls_section(
            'section_style_items',
            [
                'label' => esc_html__('Items', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'items_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
	            'default' => [
		            'top' => '15',
		            'right' => '15',
		            'bottom' => '15',
		            'left' => '15',
		            'unit'  => 'px',
		            'isLinked' => false
	            ],
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .case_items__inner_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .wgl-cases' => 'margin: -{{TOP}}{{UNIT}} -{{RIGHT}}{{UNIT}} -{{BOTTOM}}{{UNIT}} -{{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'items_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .case_items__inner_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'items_border_radius',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .case_items__inner_wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'tabs_items',
            ['separator' => 'before']
        );

        $this->start_controls_tab(
            'tab_item_idle',
            ['label' => esc_html__('Idle', 'bili-core')]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_idle',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .case_items__inner_wrapper',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_idle',
                'selector' => '{{WRAPPER}} .case_items__inner_wrapper',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_item_hover',
            ['label' => esc_html__('Hover', 'bili-core')]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_hover',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .case_items:hover .case_items__inner_wrapper',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_hover',
                'selector' => '{{WRAPPER}} .case_items:hover .case_items__inner_wrapper',
            ]
        );

        $this->add_control(
            'item_transition',
            [
                'label' => esc_html__('Transition Duration', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => ['min' => 0, 'max' => 2, 'step' => 0.1 ],
                ],
                'default' => ['size' => 0.4, 'unit' => 's'],
                'selectors' => [
                    '{{WRAPPER}} .case_items' => 'transition: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /**
         * STYLES -> TITLES
         */

        $this->start_controls_section(
            'section_style_titles',
            [
                'label' => esc_html__('Titles', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


	    $this->add_responsive_control(
		    'titles_min_width',
		    [
			    'label' => esc_html__('Min-Width', 'bili-core'),
			    'type' => Controls_Manager::SLIDER,
			    'size_units' => ['px', '%', 'vw'],
			    'range' => [
				    'px' => ['min' => 0, 'max' => 800, 'step' => 1 ],
				    '%' => ['min' => 0, 'max' => 100, 'step' => 1 ],
				    'vw' => ['min' => 0, 'max' => 100, 'step' => 1 ],
			    ],
			    'default' => ['size' => 80, 'unit' => 'px'],
			    'selectors' => [
				    '{{WRAPPER}} .case_title' => 'min-width: {{SIZE}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_responsive_control(
		    'titles_min_height',
		    [
			    'label' => esc_html__('Min-Height', 'bili-core'),
			    'type' => Controls_Manager::SLIDER,
			    'size_units' => ['px', '%', 'vw'],
			    'range' => [
				    'px' => ['min' => 0, 'max' => 800, 'step' => 1 ],
				    '%' => ['min' => 0, 'max' => 100, 'step' => 1 ],
				    'vw' => ['min' => 0, 'max' => 100, 'step' => 1 ],
			    ],
			    'default' => ['size' => 80, 'unit' => 'px'],
			    'selectors' => [
				    '{{WRAPPER}} .case_title' => 'min-height: {{SIZE}}{{UNIT}};',
			    ],
		    ]
	    );

        $this->add_responsive_control(
            'titles_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .case_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'titles_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .case_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'titles_border_radius',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
	            'default' => [
		            'top' => '80',
		            'right' => '80',
		            'bottom' => '80',
		            'left' => '80',
		            'unit'  => 'px',
		            'isLinked' => false
	            ],
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .case_title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'tabs_titles',
            ['separator' => 'before']
        );

        $this->start_controls_tab(
            'tab_titles_idle',
            ['label' => esc_html__('Idle', 'bili-core')]
        );

	    $this->add_control(
		    'titles_color_idle',
		    [
			    'label' => esc_html__('Color', 'bili-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => ['active' => true],
                'default' => WGL_Globals::get_tertiary_color(),
			    'selectors' => [
				    '{{WRAPPER}} .case_title' => 'color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'titles_bg_color_idle',
		    [
			    'label' => esc_html__('Background Color', 'bili-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => ['active' => true],
			    'default' => WGL_Globals::get_h_font_color(),
			    'selectors' => [
				    '{{WRAPPER}} .case_title::before' => 'background-color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'titles_shadow_idle',
                'selector' => '{{WRAPPER}} .case_title',
            ]
        );

	    $this->add_control(
		    'titles_opacity_idle',
		    [
			    'label' => esc_html__('Opacity', 'bili-core'),
			    'type' => Controls_Manager::SLIDER,
			    'size_units' => ['px'],
			    'range' => [
				    'px' => ['min' => 0, 'max' => 1, 'step' => 0.02 ],
			    ],
			    'default' => ['size' => 0, 'unit' => 'px'],
			    'selectors' => [
				    '{{WRAPPER}} .case_title' => 'opacity: {{SIZE}};',
			    ],
		    ]
	    );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_titles_hover',
            ['label' => esc_html__('Hover', 'bili-core')]
        );


	    $this->add_control(
		    'titles_color_hover',
		    [
			    'label' => esc_html__('Color', 'bili-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => ['active' => true],
			    'selectors' => [
				    '{{WRAPPER}} .case_items:hover .case_title' => 'color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'titles_bg_color_hover',
		    [
			    'label' => esc_html__('Background Color', 'bili-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => ['active' => true],
			    'selectors' => [
				    '{{WRAPPER}} .case_items:hover .case_title::before' => 'background-color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'titles_hover',
                'selector' => '{{WRAPPER}} .case_items:hover',
            ]
        );

	    $this->add_control(
		    'titles_opacity_hover',
		    [
			    'label' => esc_html__('Opacity', 'bili-core'),
			    'type' => Controls_Manager::SLIDER,
			    'size_units' => ['px'],
			    'range' => [
				    'px' => ['min' => 0, 'max' => 1, 'step' => 0.02 ],
			    ],
			    'default' => ['size' => 1, 'unit' => 'px'],
			    'selectors' => [
				    '{{WRAPPER}} .case_items:hover .case_title' => 'opacity: {{SIZE}};',
			    ],
		    ]
	    );

        $this->add_control(
            'titles_transition',
            [
                'label' => esc_html__('Transition Duration', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => ['min' => 0, 'max' => 2, 'step' => 0.1 ],
                ],
                'default' => ['size' => 0.4, 'unit' => 's'],
                'selectors' => [
                    '{{WRAPPER}} .case_title' => 'transition: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /**
         * STYLES -> IMAGES
         */

        $this->start_controls_section(
            'section_style_images',
            [
                'label' => esc_html__('Images', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

	    $this->add_responsive_control(
		    'thumbnail_width',
		    [
			    'label' => esc_html__('Image Width', 'bili-core'),
			    'type' => Controls_Manager::SLIDER,
			    'range' => [
				    'px' => ['min' => 10, 'max' => 500 ],
				    '%' => ['min' => 10, 'max' => 100 ],
			    ],
			    'size_units' => ['px', '%'],
			    'selectors' => [
				    '{{WRAPPER}} .case_items img' => 'width: {{SIZE}}{{UNIT}};',
			    ],
			    'label_block' => true,
		    ]
	    );

	    $this->start_controls_tabs('images');

        $this->start_controls_tab(
            'image_idle',
            ['label' => esc_html__('Idle', 'bili-core')]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_shadow_idle',
                'selector' => '{{WRAPPER}} .image_wrapper img',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'image_border_idle',
                'selector' => '{{WRAPPER}} .image_wrapper img',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'image_hover',
            ['label' => esc_html__('Hover', 'bili-core')]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_shadow_hover',
                'selector' => '{{WRAPPER}} .case_items:hover .image_wrapper img',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'image_border_hover',
                'selector' => '{{WRAPPER}} .case_items:hover .image_wrapper img',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

	    /**
	     * STYLE -> BUTTON
	     */

	    $this->start_controls_section(
		    'section_style_button',
		    [
			    'label' => esc_html__('Button', 'bili-core'),
			    'tab' => Controls_Manager::TAB_STYLE,
		    ]
	    );

	    $this->add_group_control(
		    Group_Control_Typography::get_type(),
		    [
			    'name' => 'button_custom_fonts',
			    'selector' => '{{WRAPPER}} .wgl-cases__button span',
		    ]
	    );

	    $this->add_responsive_control(
		    'button_margin',
		    [
			    'label' => esc_html__('Margin', 'bili-core'),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => ['px', '%'],
			    'default' => [
				    'top' => '25',
				    'right' => '0',
				    'bottom' => '0',
				    'left' => '0',
				    'unit'  => 'px',
				    'isLinked' => false
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-cases__button_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_responsive_control(
		    'button_padding',
		    [
			    'label' => esc_html__('Padding', 'bili-core'),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => ['px', 'em', '%'],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-cases__button_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_responsive_control(
		    'button_inner_padding',
		    [
			    'label' => esc_html__('Inner Padding', 'bili-core'),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => ['px', 'em', '%'],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-cases__button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_responsive_control(
		    'button_radius',
		    [
			    'label' => esc_html__('Border Radius', 'bili-core'),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => ['px', '%'],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-cases__button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_group_control(
		    Group_Control_Border::get_type(),
		    [
			    'name' => 'button_border',
			    'render_type' => 'template',
			    'dynamic' => ['active' => true],
			    'fields_options' => [
				    'color' => ['type' => Controls_Manager::HIDDEN],
			    ],
			    'selector' => '{{WRAPPER}} .wgl-cases__button',
		    ]
	    );

	    $this->add_responsive_control(
		    'button_icon_size',
		    [
			    'label' => esc_html__('Icon Size', 'bili-core'),
			    'type' => Controls_Manager::SLIDER,
			    'size_units' => ['px', 'em', 'rem'],
			    'range' => [
				    'px' => ['min' => 6, 'max' => 300],
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .read-more-icon' => 'font-size: {{SIZE}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_responsive_control(
		    'button_alignment',
		    [
			    'label' => esc_html__('Alignment', 'bili-core'),
			    'type' => Controls_Manager::CHOOSE,
			    'toggle' => true,
			    'options' => [
				    'flex-start' => [
					    'title' => esc_html__('Left', 'bili-core'),
					    'icon' => 'eicon-text-align-left',
				    ],
				    'center' => [
					    'title' => esc_html__('Center', 'bili-core'),
					    'icon' => 'eicon-text-align-center',
				    ],
				    'flex-end' => [
					    'title' => esc_html__('Right', 'bili-core'),
					    'icon' => 'eicon-text-align-right',
				    ],
				    'space-between' => [
					    'title' => esc_html__('Justify', 'bili-core'),
					    'icon' => 'eicon-text-align-justify',
				    ],
			    ],
			    'default' => 'space-between',
			    'selectors' => [
				    '{{WRAPPER}} .wgl-cases__button' => 'justify-content: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'read_more_icon_position',
		    [
			    'label' => esc_html__('Position', 'bili-core'),
			    'type' => Controls_Manager::SELECT,
			    'options' => [
				    'left' => esc_html__( 'Before', 'bili-core' ),
				    'right' => esc_html__( 'After', 'bili-core' ),
			    ],
			    'default' => 'right',
		    ]
	    );

	    $this->add_control(
		    'read_more_icon_indent',
		    [
			    'label' => esc_html__( 'Offset', 'bili-core' ),
			    'type' => Controls_Manager::SLIDER,
			    'range' => [
				    'px' => [ 'max' => 250 ],
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .align-icon-right .read-more-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
				    '{{WRAPPER}} .align-icon-left .read-more-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'button_icon_rotate',
		    [
			    'label' => esc_html__('Rotate', 'bili-core'),
			    'type' => Controls_Manager::SLIDER,
			    'size_units' => ['deg', 'turn'],
			    'range' => [
				    'deg' => ['max' => 360],
				    'turn' => ['min' => 0, 'max' => 1, 'step' => 0.1],
			    ],
			    'default' => ['unit' => 'deg'],
			    'selectors' => [
				    '{{WRAPPER}} .read-more-icon:before' => 'transform: rotate({{SIZE}}{{UNIT}}); display: inline-block;',
			    ],
		    ]
	    );

	    $this->start_controls_tabs(
		    'tabs_button',
		    ['separator' => 'before']
	    );

	    $this->start_controls_tab(
		    'tab_button_idle',
		    ['label' => esc_html__('Idle', 'bili-core')]
	    );

	    $this->add_control(
		    'button_color_idle',
		    [
			    'label' => esc_html__('Text Color', 'bili-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => ['active' => true],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-cases__button' => 'color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'button_bg_idle',
		    [
			    'label' => esc_html__('Additional Color', 'bili-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => ['active' => true],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-cases__button' => 'background-color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'button_icon_color_idle',
		    [
			    'label' => esc_html__('Icon Color', 'bili-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => ['active' => true],
			    'selectors' => [
				    '{{WRAPPER}} .read-more-icon' => 'color: {{VALUE}}'
			    ],
		    ]
	    );

	    $this->add_control(
		    'button_border_color_idle',
		    [
			    'label' => esc_html__('Border Color', 'bili-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => ['active' => true],
			    'condition' => [
				    'button_border_border!' => '',
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-cases__button' => 'border-color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->end_controls_tab();

	    $this->start_controls_tab(
		    'tab_button_hover',
		    ['label' => esc_html__('Hover', 'bili-core')]
	    );

	    $this->add_control(
		    'button_color_hover',
		    [
			    'label' => esc_html__('Text Color', 'bili-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => ['active' => true],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-cases__button:hover' => 'color: {{VALUE}};',
				    '{{WRAPPER}} .wgl-cases__link:hover ~ .wgl-cases__button_wrapper .wgl-cases__button' => 'color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'button_bg_hover',
		    [
			    'label' => esc_html__('Additional Hover Color', 'bili-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => ['active' => true],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-cases__button:hover,
                     {{WRAPPER}} .wgl-cases__link:hover ~ .wgl-cases__button_wrapper .wgl-cases__button' => 'background-color: {{VALUE}}',
			    ],
		    ]
	    );

	    $this->add_control(
		    'button_icon_color_hover',
		    [
			    'label' => esc_html__('Icon Color', 'bili-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => ['active' => true],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-cases__button .read-more-icon' => '--icon-color-hover: {{VALUE}}'
			    ],
		    ]
	    );

	    $this->add_control(
		    'button_border_color_hover',
		    [
			    'label' => esc_html__('Border Color', 'bili-core'),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => ['active' => true],
			    'default' => 'rgba(255,255,255,0)',
			    'condition' => [
				    'button_border_border!' => '',
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-cases__button:hover,
				     {{WRAPPER}} .wgl-cases__link:hover ~ .wgl-cases__button_wrapper .wgl-cases__button' => 'border-color: {{VALUE}}'
			    ],
		    ]
	    );

	    $this->end_controls_tab();
	    $this->end_controls_tabs();
	    $this->end_controls_section();
    }

    protected function render()
    {
        extract($this->get_settings_for_display());

        $this->add_render_attribute(
            'wrapper',
            [
                'class' => [
                    'wgl-cases',
                    'clearfix',
                ],
                'data-carousel' => $use_carousel
            ]
        );

        // Render
        echo '<div ', $this->get_render_attribute_string('wrapper'), '>',
            $this->get_cases_html(),
        '</div>';
    }

    protected function get_cases_html()
    {
        extract($this->get_settings_for_display());

        $content = '';
        foreach ($list as $index => $item) {

	        $btn_icon = '';
            $has_link = !empty($item['link']['url']);
	        $btn = $this->get_repeater_setting_key('btn', 'list', $index);

	        // Media
	        $media = new WGL_Icons;
	        $ib_media = $media->build($this, $item, []);

	        if ($has_link) {
                $link = $this->get_repeater_setting_key('link', 'list', $index);
                $this->add_link_attributes($link, $item['link']);
            }

	        if($item['read_more_icon_fontawesome']['value']) {
		        $btn_icon = $this->get_repeater_setting_key('btn-icon', 'list', $index);
		        $migrated = isset( $atts['__fa4_migrated']['read_more_icon_fontawesome'] );
		        $is_new = Icons_Manager::is_migration_allowed();
		        if ( $is_new || $migrated ) {
			        $this->add_render_attribute(
				        [
					        $btn_icon => [
						        'class' => [
							        esc_attr( $item['read_more_icon_fontawesome']['value'] ),
							        'read-more-icon',
						        ],
					        ],
				        ]
			        );
		        }

		        $this->add_render_attribute([$btn => [
		        	'class' => 'align-icon-' . esc_attr($read_more_icon_position) . ' wgl-cases__button button-read-more'
		        ]]);
	        }else{
		        $this->add_render_attribute([$btn => ['class', 'button-read-more']]);
	        }

	        $ib_button = '<div class="wgl-cases__button_wrapper">';
	        $ib_button .= sprintf(
		        '<%s %s %s>',
		        $module_link || !$has_link ? 'div' : 'a',
		        $module_link || !$has_link ? '' : $this->get_render_attribute_string($link),
		        $this->get_render_attribute_string($btn)
	        );
	        $ib_button .= $item['read_more_icon_fontawesome']['value'] && 'left' === $read_more_icon_position ? '<i ' . $this->get_render_attribute_string($btn_icon) . '></i>' :'';
	        $ib_button .= $item['read_more_text'] ? '<span>' . esc_html($item['read_more_text']) . '</span>' : '';
	        $ib_button .= $item['read_more_icon_fontawesome']['value'] && 'left' !== $read_more_icon_position ? '<i ' . $this->get_render_attribute_string($btn_icon) . '></i>' :'';
	        $ib_button .= $module_link || !$has_link ? '</div>' : '</a>';
	        $ib_button .= '</div>';

	        $title = '';
	        if (!empty($item['title'])){
		        $title .= '<div class="case_title__wrapper">';
		        $title .= sprintf(
			        '<%s %s %s>',
			        $module_link || !$has_link ? 'div' : 'a',
			        $module_link || !$has_link ? '' : $this->get_render_attribute_string($link),
			        ' class="case_title"'
		        );
		        $title .= $item['title'];
		        $title .= $module_link || !$has_link ? '</div>' : '</a>';
		        $title .= '</div>';
	        }

            ob_start();

            echo '<div class="case_items elementor-repeater-item-'. $item['_id'] . (($use_carousel) ? ' swiper-slide' : '') .'"><div class="case_items__inner_wrapper">';

		        if ($module_link && $has_link) {
			        echo '<a class="wgl-cases__link" ' . $this->get_render_attribute_string($link) . '></a>';
		        }
                echo '<div class="image_wrapper">';

	                echo $ib_media;

	                echo $title ?? '';

                echo '</div>';

	            echo $ib_button;

            echo '</div></div>';

            $content .= ob_get_clean();
        }

        return !$use_carousel ? $content : $this->apply_carousel_settings($content);
    }

    protected function apply_carousel_settings($content)
    {
        extract($this->get_settings_for_display());

        $options = [
            'slides_per_row' => $item_grid['size'] ?? 4,
            'autoplay' => $autoplay,
            'autoplay_speed' => $autoplay_speed,
            'fade_animation' => $fade_animation,
            'slider_infinite' => $slider_infinite,
            'slide_per_single'  => $slide_per_single,
            'center_mode' => $center_mode,
            // Pagination
            'use_pagination' => $use_pagination,
            'pagination_type' => $pagination_type,
            // Navigation
            'use_navigation' => $use_navigation,
            'navigation_position' => $navigation_position,
            'navigation_view' => $navigation_view,
            // Responsive
            'customize_responsive' => $customize_responsive,
            'desktop_breakpoint' => $desktop_breakpoint,
            'desktop_slides' => $desktop_slides,
            'tablet_breakpoint' => $tablet_breakpoint,
            'tablet_slides' => $tablet_slides,
            'mobile_breakpoint' => $mobile_breakpoint,
            'mobile_slides' => $mobile_slides,
        ];

        return WGL_Carousel_Settings::init($options, $content);
    }

    public function wpml_support_module() {
        add_filter( 'wpml_elementor_widgets_to_translate',  [$this, 'wpml_widgets_to_translate_filter']);
    }

    public function wpml_widgets_to_translate_filter( $widgets ){
        return \WGL_Extensions\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }
}
