<?php
/**
 * This template can be overridden by copying it to `bili[-child]/bili-core/elementor/widgets/wgl-contact-form-7.php`.
 */
namespace WGL_Extensions\Widgets;

defined( 'ABSPATH' ) || exit; // Abort, if called directly.

use Elementor\{
    Widget_Base,
    Controls_Manager,
    Group_Control_Border,
    Group_Control_Typography,
    Group_Control_Box_Shadow,
    Group_Control_Background
};

class WGL_Contact_Form_7 extends Widget_Base
{
    protected $forms;

    public function get_name()
    {
        return 'wgl-contact-form-7';
    }

    public function get_title()
    {
        return esc_html__( 'WGL Contact Form 7', 'bili-core' );
    }

    public function get_icon()
    {
        return 'wgl-contact-form-7';
    }

    public function get_categories()
    {
        return [ 'wgl-modules' ];
    }

    protected function get_availbale_forms($id = false)
    {
        if ( ! class_exists( 'WPCF7_ContactForm' ) ) {
            return [];
        }

        $forms = \WPCF7_ContactForm::find( [
            'orderby' => 'title',
            'order' => 'ASC',
        ] );

        if ( empty( $forms ) ) {
            return [];
        }

        $result = [];

        foreach ( $forms as $item ) {
            $key = sprintf( '%1$s::%2$s', $item->name(), $item->title() );
            $result[ $key ] = $item->title();
            $this->forms[$item->name()] = $item->id();
        }

        return $result;
    }

    protected function register_controls()
    {
        /** CONTENT -> GENERAL */

        $this->start_controls_section(
            'section_content_general',
            [
                'label' => esc_html__( 'General', 'bili-core' ),
            ]
        );

        $avaliable_forms = $this->get_availbale_forms();

        $active_form = '';

        if ( ! empty( $avaliable_forms ) ) {
            $active_form = array_keys( $avaliable_forms )[ 0 ];
        }

        $this->add_control(
            'form_shortcode',
            [
                'label' => esc_html__( 'Select Form', 'bili-core' ),
                'type' => Controls_Manager::SELECT,
                'default' => $active_form,
                'options' => $avaliable_forms,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'general_typo',
                'selector' => '{{WRAPPER}} .wpcf7-form',
            ]
        );

        $this->add_control(
            'general_color',
            [
                'label' => esc_html__( 'Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-form' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'additional_color',
            [
                'label' => esc_html__( 'Additional Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} input[type="radio"] + label:before,
                    {{WRAPPER}} input[type="radio"] + span:before,
                    {{WRAPPER}} input[type="checkbox"] + label:before,
                    {{WRAPPER}} input[type="checkbox"] + span:before' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label' => esc_html__( 'Alignment', 'bili-core' ),
                'type' => Controls_Manager::CHOOSE,
                'separator' => 'before',
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bili-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bili-core' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bili-core' ),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'prefix_class' => 'a%s',
                'default' => 'left',
            ]
        );

        $this->add_control(
            'form_inline',
            [
                'label' => esc_html__( 'Form Inline', 'bili-core' ),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-form-control-wrap,
                     {{WRAPPER}} .wpcf7-form-control.wpcf7-submit' => 'display: inline-block; vertical-align: top;',

                    '{{WRAPPER}} .wpcf7-form-control-wrap + br' => 'display: none;',
                ]
            ]
        );

        $this->add_responsive_control(
            'form_inline_width',
            [
                'label' => esc_html__( 'Inputs Width', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'condition' => [ 'form_inline!' => '' ],
                'size_units' => [ 'px', '%', 'vw' ],
                'range' => [
                    'px' => [ 'min' => 200, 'max' => 600 ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-form-control-wrap' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /**  STYLE -> INPUTS */

        $this->start_controls_section(
            'style_inputs',
            [ 'label' => esc_html__( 'Inputs', 'bili-core' ) ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'inputs_typography',
                'selector' => '{{WRAPPER}} input[type="text"],'
                            . '{{WRAPPER}} input[type="url"],'
                            . '{{WRAPPER}} input[type="search"],'
                            . '{{WRAPPER}} input[type="email"],'
                            . '{{WRAPPER}} input[type="password"],'
                            . '{{WRAPPER}} input[type="tel"],'
                            . '{{WRAPPER}} input[type="time"],'
                            . '{{WRAPPER}} input[type="number"],'
                            . '{{WRAPPER}} input[type="date"],'
                            . '{{WRAPPER}} select,'
                            . '{{WRAPPER}} textarea,'
                            . '{{WRAPPER}} input.wpcf7-form-control::placeholder,'
                            . '{{WRAPPER}} select.wpcf7-select::placeholder,'
                            . '{{WRAPPER}} textarea.wpcf7-textarea::placeholder',
            ]
        );

        $this->add_responsive_control(
            'inputs_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-form-control-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                    '{{WRAPPER}} .wpcf7-form-control-wrap input,
                     {{WRAPPER}} .wpcf7-form-control-wrap select,
                     {{WRAPPER}} .wpcf7-form-control-wrap textarea' => 'margin-bottom: calc({{BOTTOM}}{{UNIT}} - {{BOTTOM}}{{UNIT}});',
                ],
            ]
        );

        $this->add_responsive_control(
            'inputs_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} input[type="text"],
                     {{WRAPPER}} input[type="url"],
                     {{WRAPPER}} input[type="search"],
                     {{WRAPPER}} input[type="email"],
                     {{WRAPPER}} input[type="password"],
                     {{WRAPPER}} input[type="tel"],
                     {{WRAPPER}} input[type="time"],
                     {{WRAPPER}} input[type="number"],
                     {{WRAPPER}} input[type="date"],
                     {{WRAPPER}} select,
                     {{WRAPPER}} textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'inputs_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} input[type="text"],
                     {{WRAPPER}} input[type="url"],
                     {{WRAPPER}} input[type="search"],
                     {{WRAPPER}} input[type="email"],
                     {{WRAPPER}} input[type="password"],
                     {{WRAPPER}} input[type="tel"],
                     {{WRAPPER}} input[type="time"],
                     {{WRAPPER}} input[type="number"],
                     {{WRAPPER}} input[type="date"],
                     {{WRAPPER}} select,
                     {{WRAPPER}} textarea' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'inputs_height',
            [
                'label' => esc_html__( 'Inputs Height', 'bili-core' ),
                'type' => Controls_Manager::NUMBER,
                'separator' => 'before',
                'min' => 30,
                'selectors' => [
                    '{{WRAPPER}} input[type="text"],
                     {{WRAPPER}} input[type="url"],
                     {{WRAPPER}} input[type="search"],
                     {{WRAPPER}} input[type="email"],
                     {{WRAPPER}} input[type="password"],
                     {{WRAPPER}} input[type="tel"],
                     {{WRAPPER}} input[type="time"],
                     {{WRAPPER}} input[type="number"],
                     {{WRAPPER}} input[type="date"],
                     {{WRAPPER}} select' => 'height: {{VALUE}}px; min-height: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'textarea_height',
            [
                'label' => esc_html__( 'Textarea Height', 'bili-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 60,
                'selectors' => [
                    '{{WRAPPER}} textarea' => 'height: {{VALUE}}px; min-height: {{VALUE}}px;',
                ],
            ]
        );

        $this->start_controls_tabs(
            'inputs_colors_tabs',
            [ 'separator' => 'before' ]
        );

        $this->start_controls_tab(
            'inputs_idle',
            [ 'label' => esc_html__( 'Idle', 'bili-core' ) ]
        );

        $this->add_control(
            'inputs_placeholder_color_idle',
            [
                'label' => esc_html__( 'Placeholder Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} input.wpcf7-form-control::placeholder,
                     {{WRAPPER}} select.wpcf7-select::placeholder,
                     {{WRAPPER}} textarea.wpcf7-textarea::placeholder' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'inputs_idle_color',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} input[type="text"],
                     {{WRAPPER}} input[type="url"],
                     {{WRAPPER}} input[type="search"],
                     {{WRAPPER}} input[type="email"],
                     {{WRAPPER}} input[type="password"],
                     {{WRAPPER}} input[type="tel"],
                     {{WRAPPER}} input[type="time"],
                     {{WRAPPER}} input[type="number"],
                     {{WRAPPER}} input[type="date"],
                     {{WRAPPER}} select,
                     {{WRAPPER}} textarea' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'inputs_idle_border',
                'fields_options' => [
                    'width' => [ 'label' => esc_html__( 'Border Width', 'bili-core' ) ],
                    'color' => [ 'label' => esc_html__( 'Border Color', 'bili-core' ) ],
                ],
                'selector' => '{{WRAPPER}} input[type="text"],'
                            . '{{WRAPPER}} input[type="url"],'
                            . '{{WRAPPER}} input[type="search"],'
                            . '{{WRAPPER}} input[type="email"],'
                            . '{{WRAPPER}} input[type="password"],'
                            . '{{WRAPPER}} input[type="tel"],'
                            . '{{WRAPPER}} input[type="time"],'
                            . '{{WRAPPER}} input[type="number"],'
                            . '{{WRAPPER}} input[type="date"],'
                            . '{{WRAPPER}} select,'
                            . '{{WRAPPER}} textarea',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'inputs_idle_bg',
                'fields_options' => [
                    'color' => [ 'label' => esc_html__( 'Background Color', 'bili-core' ) ],
                    'image' => [ 'label' => esc_html__( 'Background Image', 'bili-core' ) ],
                ],
                'selector' => '{{WRAPPER}} input[type="text"],'
                            . '{{WRAPPER}} input[type="url"],'
                            . '{{WRAPPER}} input[type="search"],'
                            . '{{WRAPPER}} input[type="email"],'
                            . '{{WRAPPER}} input[type="password"],'
                            . '{{WRAPPER}} input[type="tel"],'
                            . '{{WRAPPER}} input[type="time"],'
                            . '{{WRAPPER}} input[type="number"],'
                            . '{{WRAPPER}} input[type="date"],'
                            . '{{WRAPPER}} select,'
                            . '{{WRAPPER}} textarea',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'inputs_idle_shadow',
                'selector' => '{{WRAPPER}} input[type="text"],'
                    . '{{WRAPPER}} input[type="url"],'
                    . '{{WRAPPER}} input[type="search"],'
                    . '{{WRAPPER}} input[type="email"],'
                    . '{{WRAPPER}} input[type="password"],'
                    . '{{WRAPPER}} input[type="tel"],'
                    . '{{WRAPPER}} input[type="time"],'
                    . '{{WRAPPER}} input[type="number"],'
                    . '{{WRAPPER}} input[type="date"],'
                    . '{{WRAPPER}} select,'
                    . '{{WRAPPER}} textarea',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'inputs_focus',
            [ 'label' => esc_html__( 'Focus', 'bili-core' ) ]
        );

        $this->add_control(
            'inputs_focus_color',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} input[type="text"]:focus,
                     {{WRAPPER}} input[type="url"]:focus,
                     {{WRAPPER}} input[type="search"]:focus,
                     {{WRAPPER}} input[type="email"]:focus,
                     {{WRAPPER}} input[type="password"]:focus,
                     {{WRAPPER}} input[type="tel"]:focus,
                     {{WRAPPER}} input[type="time"]:focus,
                     {{WRAPPER}} input[type="number"]:focus,
                     {{WRAPPER}} input[type="date"]:focus,
                     {{WRAPPER}} select:focus,
                     {{WRAPPER}} textarea:focus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'inputs_focus_border',
                'fields_options' => [
                    'width' => [ 'label' => esc_html__( 'Border Width', 'bili-core' ) ],
                    'color' => [ 'label' => esc_html__( 'Border Color', 'bili-core' ) ],
                ],
                'selector' => '{{WRAPPER}} input[type="text"]:focus,'
                    . '{{WRAPPER}} input[type="url"]:focus,'
                    . '{{WRAPPER}} input[type="search"]:focus,'
                    . '{{WRAPPER}} input[type="email"]:focus,'
                    . '{{WRAPPER}} input[type="password"]:focus,'
                    . '{{WRAPPER}} input[type="tel"]:focus,'
                    . '{{WRAPPER}} input[type="time"]:focus,'
                    . '{{WRAPPER}} input[type="number"]:focus,'
                    . '{{WRAPPER}} input[type="date"]:focus,'
                    . '{{WRAPPER}} select:focus,'
                    . '{{WRAPPER}} textarea:focus',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'inputs_focus_bg',
                'fields_options' => [
                    'color' => [ 'label' => esc_html__( 'Background Color', 'bili-core' ) ],
                    'image' => [ 'label' => esc_html__( 'Background Image', 'bili-core' ) ],
                ],
                'selector' => '{{WRAPPER}} input[type="text"]:focus,'
                    . '{{WRAPPER}} input[type="url"]:focus,'
                    . '{{WRAPPER}} input[type="search"]:focus,'
                    . '{{WRAPPER}} input[type="email"]:focus,'
                    . '{{WRAPPER}} input[type="password"]:focus,'
                    . '{{WRAPPER}} input[type="tel"]:focus,'
                    . '{{WRAPPER}} input[type="time"]:focus,'
                    . '{{WRAPPER}} input[type="number"]:focus,'
                    . '{{WRAPPER}} input[type="date"]:focus,'
                    . '{{WRAPPER}} select:focus,'
                    . '{{WRAPPER}} textarea:focus',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'inputs_focus_shadow',
                'selector' => '{{WRAPPER}} input[type="text"]:focus,'
                    . '{{WRAPPER}} input[type="url"]:focus,'
                    . '{{WRAPPER}} input[type="search"]:focus,'
                    . '{{WRAPPER}} input[type="email"]:focus,'
                    . '{{WRAPPER}} input[type="password"]:focus,'
                    . '{{WRAPPER}} input[type="tel"]:focus,'
                    . '{{WRAPPER}} input[type="time"]:focus,'
                    . '{{WRAPPER}} input[type="number"]:focus,'
                    . '{{WRAPPER}} input[type="date"]:focus,'
                    . '{{WRAPPER}} select:focus,'
                    . '{{WRAPPER}} textarea:focus',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'inputs_not_valid',
            [ 'label' => esc_html__( 'Not Valid', 'bili-core' ) ]
        );

        $this->add_control(
            'inputs_not_valid_color',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-not-valid' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'inputs_not_valid_border',
                'fields_options' => [
                    'width' => [ 'label' => esc_html__( 'Border Width', 'bili-core' ) ],
                    'color' => [ 'label' => esc_html__( 'Border Color', 'bili-core' ) ],
                ],
                'selector' => '{{WRAPPER}} .wpcf7-not-valid',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'inputs_not_valid_bg',
                'fields_options' => [
                    'color' => [ 'label' => esc_html__( 'Background Color', 'bili-core' ) ],
                    'image' => [ 'label' => esc_html__( 'Background Image', 'bili-core' ) ],
                ],
                'selector' => '{{WRAPPER}} .wpcf7-not-valid',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'inputs_not_valid_shadow',
                'selector' => '{{WRAPPER}} .wpcf7-not-valid',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /** STYLE -> SUBMIT */

        $this->start_controls_section(
            'section_style_submit',
            [ 'label' => esc_html__( 'Submit Button', 'bili-core' ) ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'submit_typography',
                'selector' => '{{WRAPPER}} .wpcf7-submit'
            ]
        );

        $this->add_responsive_control(
            'submit_full_width',
            [
                'label' => esc_html__( 'Full Width', 'bili-core' ),
                'type' => Controls_Manager::SWITCHER,
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-submit' => 'width: 100%;',
                ]
            ]
        );

        $this->add_responsive_control(
            'submit_min_width',
            [
                'label' => esc_html__( 'Button min Width', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [ 'min' => 50, 'max' => 200 ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-submit' => 'min-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'submit_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-submit' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .wgl-button.has-animated-bg .wpcf7-submit' => 'margin: 0;',
                    '{{WRAPPER}} .wgl-button.has-animated-bg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'submit_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-submit' => 'height: auto; padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .wgl-button.has-animated-bg .wpcf7-submit' => 'padding: 0;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'submit_border',
                'fields_options' => [
                    'width' => [ 'label' => esc_html__( 'Border Width', 'bili-core' ) ],
                    'color' => [ 'type' => Controls_Manager::HIDDEN ],
                ],
                'selector' => '{{WRAPPER}} .wpcf7-submit',
            ]
        );

        $this->add_responsive_control(
            'submit_radius',
            [
                'label' => esc_html__( 'Border Radius', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-submit' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'submit' );

        $this->start_controls_tab(
            'submit_idle',
            [ 'label' => esc_html__( 'Idle', 'bili-core' ) ]
        );

        $this->add_control(
            'submit_color_idle',
            [
                'label' => esc_html__( 'Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-submit' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'submit_boder_color_idle',
            [
                'label' => esc_html__( 'Border Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [ 'submit_border_border!' => '' ],
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-submit' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'submit_bg_idle',
                'fields_options' => [
                    'color' => [ 'label' => esc_html__( 'Background Color', 'bili-core' ) ],
                    'image' => [ 'label' => esc_html__( 'Background Image', 'bili-core' ) ],
                ],
                'selector' => '
                    {{WRAPPER}} .wpcf7-submit,
                    {{WRAPPER}} .wgl-button.has-animated-bg:before
                ',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'submit_shadow_idle',
                'selector' => '{{WRAPPER}} .wpcf7-submit',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'submit_hover',
            [ 'label' => esc_html__( 'Hover', 'bili-core' ) ]
        );

        $this->add_control(
            'submit_color_hover',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-submit:hover' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'submit_boder_color_hover',
            [
                'label' => esc_html__( 'Border Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [ 'submit_border_border!' => '' ],
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-submit:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'submit_bg_hover',
                'fields_options' => [
                    'color' => [ 'label' => esc_html__( 'Background Color', 'bili-core' ) ],
                    'image' => [ 'label' => esc_html__( 'Background Image', 'bili-core' ) ],
                ],
                'selector' => '
                    {{WRAPPER}} .wpcf7-submit:hover,
                    {{WRAPPER}} .wgl-button.has-animated-bg:hover:before
                ',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'submit_shadow_hover',
                'selector' => '{{WRAPPER}} .wpcf7-submit:hover'
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /** STYLE -> NOT VALID TIP */

        $this->start_controls_section(
            'section_style_tip',
            [ 'label' => esc_html__( 'Not Valid Tip', 'bili-core' ) ]
        );

        $this->add_responsive_control(
            'tip_alignment',
            [
                'label' => esc_html__( 'Alignment', 'bili-core' ),
                'type' => Controls_Manager::CHOOSE,
                'separator' => 'before',
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bili-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bili-core' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bili-core' ),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'selectors'  => [
                    '{{WRAPPER}} .wpcf7-not-valid-tip' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'tip_typo',
                'selector' => '{{WRAPPER}} .wpcf7-not-valid-tip',
            ]
        );

        $this->add_responsive_control(
            'tip_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-not-valid-tip' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'tip_color',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-not-valid-tip' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /** STYLE -> RESPONSE */

        $this->start_controls_section(
            'section_style_response',
            [ 'label' => esc_html__( 'Alert', 'bili-core' ) ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'response_typo',
                'selector' => '{{WRAPPER}} .wpcf7-response-output',
            ]
        );

        $this->add_responsive_control(
            'response_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-response-output' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'response_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-response-output' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'response_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-response-output' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'response_bg',
                'fields_options' => [
                    'color' => [ 'label' => esc_html__( 'Background Color', 'bili-core' ) ],
                    'image' => [ 'label' => esc_html__( 'Background Image', 'bili-core' ) ],
                ],
                'selector' => '{{WRAPPER}} .wpcf7-response-output',
            ]
        );

        $this->add_control(
            'response_color',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .wpcf7-response-output' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $avaliable_forms = $this->get_availbale_forms();

        $shortcode = $this->get_settings( 'form_shortcode' );

        if ( ! array_key_exists( $shortcode, $avaliable_forms ) ) {
            $shortcode = array_keys( $avaliable_forms )[ 0 ];
        }

        $data = explode( '::', $shortcode );

        if ( ! empty( $data ) && 2 === count( $data ) ) {
            echo '<div class="wgl-contact-form-7">',
                do_shortcode( sprintf( '[contact-form-7 id="%1$d" title="%2$s"]', $this->forms[ $data[ 0 ] ], $data[ 1 ] ) ),
            '</div>';
        }

    }

    public function wpml_support_module()
    {
        add_filter( 'wpml_elementor_widgets_to_translate',  [ $this, 'wpml_widgets_to_translate_filter' ] );
    }

    public function wpml_widgets_to_translate_filter( $widgets )
    {
        return \WGL_Extensions\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }
}