<?php
/**
 * This template can be overridden by copying it to `bili[-child]/bili-core/elementor/widgets/wgl-pricing-table.php`.
 */
namespace WGL_Extensions\Widgets;

defined( 'ABSPATH' ) || exit; // Abort, if called directly.

use Elementor\{
    Widget_Base,
    Controls_Manager,
    Group_Control_Border,
    Group_Control_Typography,
    Group_Control_Background,
    Group_Control_Box_Shadow
};
use WGL_Extensions\{
    WGL_Framework_Global_Variables as WGL_Globals,
    Includes\WGL_Icons,
    Templates\WGL_Button
};

class WGL_Pricing_Table extends Widget_Base
{
    public function get_name()
    {
        return 'wgl-pricing-table';
    }

    public function get_title()
    {
        return esc_html__( 'WGL Pricing Table', 'bili-core' );
    }

    public function get_icon()
    {
        return 'wgl-pricing-table';
    }

    public function get_keywords()
    {
        return [ 'price', 'table' ];
    }

    public function get_categories()
    {
        return [ 'wgl-modules' ];
    }

    protected function register_controls()
    {
        /** CONTENT -> GENERAL */

        $this->start_controls_section(
            'content_general',
            [ 'label' => esc_html__( 'General', 'bili-core' ) ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label' => esc_html__( 'Alignment', 'bili-core' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bili-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bili-core' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bili-core' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'prefix_class' => 'a%s',
            ]
        );

        $this->add_control(
            'hover_animation',
            [
                'label' => esc_html__( 'Hover Animation', 'bili-core' ),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__( 'Slide up the module.', 'bili-core' ),
            ]
        );

        $this->end_controls_section();

        /** CONTENT -> CONTENT */

        $this->start_controls_section(
            'content_content',
            [ 'label' => esc_html__( 'Content', 'bili-core' ) ]
        );

	    $this->add_control(
		    'pretitle_text',
		    [
			    'label' => esc_html__('Pretitle', 'bili-core'),
			    'type' => Controls_Manager::TEXT,
			    'dynamic' => [ 'active' => true ],
			    'label_block' => true,
		    ]
	    );

        $this->add_control(
            'title_text',
            [
                'label' => esc_html__( 'Title', 'bili-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [ 'active' => true ],
                'label_block' => true,
                'placeholder' => esc_attr_x( 'ex: STANDARD', 'WGL Pricing Table', 'bili-core' ),
                'default' => esc_html_x( 'STANDARD', 'WGL Pricing Table', 'bili-core' ),
            ]
        );

        $this->add_control(
            'title_suffix_enabled',
            [
                'label' => esc_html__( 'Shatter title into parts?', 'bili-core' ),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'title_suffix_text',
            [
                'label' => esc_html__( 'Title Suffix', 'bili-core' ),
                'type' => Controls_Manager::TEXT,
                'condition' => [ 'title_suffix_enabled' => 'yes' ],
                'dynamic' => [ 'active' => true ],
                'default' => esc_html_x( ' Premium', 'WGL Pricing Table', 'bili-core' ),
            ]
        );

        $this->add_control(
            'currency_text',
            [
                'label' => esc_html__( 'Currency', 'bili-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [ 'active' => true ],
                'label_block' => true,
                'placeholder' => esc_attr_x( 'ex: USD, $, €', 'WGL Pricing Table', 'bili-core' ),
                'default' => esc_html_x( '$', 'WGL Pricing Table', 'bili-core' ),
            ]
        );

        $this->add_control(
            'price_text',
            [
                'label' => esc_html__( 'Price', 'bili-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [ 'active' => true ],
                'label_block' => true,
                'placeholder' => esc_attr_x( 'ex: 179.99', 'WGL Pricing Table', 'bili-core' ),
                'default' => esc_html_x( '180', 'WGL Pricing Table', 'bili-core' ),
            ]
        );

        $this->add_control(
            'period_text',
            [
                'label' => esc_html__( 'Period', 'bili-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [ 'active' => true ],
                'label_block' => true,
                'placeholder' => esc_attr_x( 'ex: per month, /item', 'WGL Pricing Table', 'bili-core' ),
            ]
        );

        $this->add_control(
            'content_wysiwyg',
            [
                'label' => esc_html__( 'Content', 'bili-core' ),
                'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
                'dynamic' => [ 'active' => true ],
                'default' => esc_html__( 'Your content...', 'bili-core' ),
            ]
        );

        $this->add_control(
            'description_text',
            [
                'label' => esc_html__( 'Description', 'bili-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'separator' => 'before',
                'label_block' => true,
                'rows' => 1,
            ]
        );

        $this->end_controls_section();

        /** CONTENT -> BUTTON */

        $this->start_controls_section(
            'content_button',
            [ 'label' => esc_html__( 'Button', 'bili-core' ) ]
        );

        $this->add_control(
            'button_enabled',
            [
                'label' => esc_html__( 'Use button?', 'bili-core' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Text', 'bili-core' ),
                'type' => Controls_Manager::TEXT,
                'condition' => [ 'button_enabled' => 'yes' ],
                'dynamic' => [ 'active' => true ],
                'label_block' => true,
                'placeholder' => esc_attr_x( 'ex: CHOOSE PLAN', 'WGL Pricing Table', 'bili-core' ),
                'default' => esc_html_x( 'CHOOSE PLAN', 'WGL Pricing Table', 'bili-core' ),
            ]
        );

        $this->add_control(
            'button_link',
            [
                'label' => esc_html__( 'Button Link', 'bili-core' ),
                'type' => Controls_Manager::URL,
                'condition' => [ 'button_enabled' => 'yes' ],
	            'default' => [ 'url' => '#' ],
                'label_block' => true,
            ]
        );

        $this->add_responsive_control(
            'button_alignment',
            [
                'label' => esc_html__( 'Alignment', 'bili-core' ),
                'type' => Controls_Manager::CHOOSE,
                'condition' => [ 'button_enabled' => 'yes' ],
                'options' => [
                    '-left' => [
                        'title' => esc_html__( 'Left', 'bili-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    '-center' => [
                        'title' => esc_html__( 'Center', 'bili-core' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    '-right' => [
                        'title' => esc_html__( 'Right', 'bili-core' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    '-justify' => [
                        'title' => esc_html__( 'Full Width', 'bili-core' ),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'prefix_class' => 'button-align%s',
            ]
        );

        $this->add_control(
            'button_media_heading',
            [
                'label' => esc_html__( 'Button Media', 'bili-core' ),
                'type' => Controls_Manager::HEADING,
                'condition' => [ 'button_enabled' => 'yes' ],
                'separator' => 'before',
            ]
        );

        $extra_controls[ 'img_size_string' ] = [
            'label' => esc_html__( 'Image Size', 'bili-core' ),
            'type' => Controls_Manager::SELECT,
            'condition' => [
                'icon_type' => 'image',
                'button_enabled' => 'yes',
            ],
            'options' => [
                '30' => esc_html__( '30x30', 'bili-core' ),
                '50' => esc_html__( '50x50', 'bili-core' ),
                '100' => esc_html__( '100x100', 'bili-core' ),
                'full' => esc_html__( 'Full', 'bili-core' ),
                'custom' => esc_html__( 'Custom', 'bili-core' ),
            ],
            'default' => 'full',
        ];

        $extra_controls[ 'img_size_array' ] = [
            'label' => esc_html__( 'Image Dimension', 'bili-core' ),
            'type' => Controls_Manager::IMAGE_DIMENSIONS,
            'condition' => [
                'img_size_string' => 'custom',
                'icon_type' => 'image',
                'button_enabled' => 'yes',
            ],
            'description' => esc_html__( 'Crop the original image to any custom size. You can also set a single value for width to keep the initial ratio.', 'bili-core' ),
            'default' => [
                'width' => '65',
                'height' => '65',
            ],
        ];

        $extra_controls[ 'img_aspect_ratio' ] = [
            'label' => esc_html__( 'Image Aspect Ratio', 'bili-core' ),
            'type' => Controls_Manager::SELECT,
            'condition' => [
                'img_size_string!' => 'custom',
                'icon_type' => 'image',
                'button_enabled' => 'yes',
            ],
            'options' => [
                '' => esc_html__( 'No Crop', 'bili-core' ),
                '1:1' => esc_html( '1:1' ),
                '3:2' => esc_html( '3:2' ),
                '4:3' => esc_html( '4:3' ),
                '6:5' => esc_html( '6:5' ),
                '9:16' => esc_html( '9:16' ),
                '16:9' => esc_html( '16:9' ),
                '21:9' => esc_html( '21:9' ),
            ],
            'default' => '',
        ];

        $extra_controls[ 'icon_align' ] = [
            'label' => esc_html__( 'Position', 'bili-core' ),
            'type' => Controls_Manager::SELECT,
            'condition' => [
                'icon_type!' => '',
                'button_enabled' => 'yes'
            ],
            'options' => [
                'left' => esc_html__( 'Before', 'bili-core' ),
                'right' => esc_html__( 'After', 'bili-core' ),
            ],
            'default' => 'right',
        ];

        $extra_controls[ 'icon_indent' ] = [
            'label' => esc_html__( 'Offset', 'bili-core' ),
            'type' => Controls_Manager::SLIDER,
            'condition' => [
                'icon_type!' => '',
                'button_enabled' => 'yes',
            ],
            'range' => [
                'px' => [ 'max' => 50 ],
            ],
	        'default' => ['size' => 12, 'unit' => 'px'],
            'selectors' => [
                '{{WRAPPER}} .align-icon-right .media-wrapper' => 'margin-left: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .align-icon-left .media-wrapper' => 'margin-right: {{SIZE}}{{UNIT}};',
            ],
        ];

        WGL_Icons::init(
            $this,
            [
                'output' => $extra_controls,
                'section' => false,
                'condition' => [ 'button_enabled' => 'yes' ],
                'use_group_control_image_size' => ! ( $extra_controls[ 'img_size_string' ] ?? null ),
            ]
        );

        $this->end_controls_section();

        /** STYLE -> CONTAINER */

        $this->start_controls_section(
            'style_container',
            [
                'label' => esc_html__( 'Container', 'bili-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'container_max_width',
            [
                'label' => esc_html__( 'Max Width', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [ 'min' => 250, 'max' => 850 ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-pricing_plan' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'container_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'container_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '96',
                    'right' => '0',
                    'bottom' => '50',
                    'left' => '0',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'mobile_default' => [
                    'top' => '30',
                    'right' => '0',
                    'bottom' => '30',
                    'left' => '0',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'container_border',
                'fields_options' => [
                    'width' => [ 'label' => esc_html__( 'Border Width', 'bili-core' ) ],
                    'color' => [ 'label' => esc_html__( 'Border Color', 'bili-core' ) ],
                ],
                'selector' => '{{WRAPPER}} .pricing__wrapper',
            ]
        );

        $this->add_control(
            'container_radius',
            [
                'label' => esc_html__( 'Border Radius', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'container_bg',
                'fields_options' => [
                    'background' => [
                        'default' => 'classic',
                    ],
                    'color' => [
                        'default' => '#232323',
                    ],
                ],
                'selector' => '{{WRAPPER}} .pricing__wrapper',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'container_shadow',
                'fields_options' => [
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 6,
                            'vertical' => 5,
                            'blur' => 30,
                            'spread' => 0,
                            'color' => 'rgba(0, 0, 0, 0.12)',
                        ]
                    ]
                ],
                'selector' => '{{WRAPPER}} .pricing__wrapper',
            ]
        );

        $this->add_control(
            'separate_styling_enabled',
            [
                'label' => esc_html__( 'Separate sections cusomization', 'bili-core' ),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'header_section_heading',
            [
                'label' => esc_html__( 'Header Section', 'bili-core' ),
                'type' => Controls_Manager::HEADING,
                'condition' => [ 'separate_styling_enabled' => 'yes' ],
            ]
        );

        $this->add_responsive_control(
            'header_section_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [ 'separate_styling_enabled' => 'yes' ],
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '0',
                    'right' => '48',
                    'bottom' => '0',
                    'left' => '48',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'mobile_default' => [
                    'top' => '10',
                    'right' => '20',
                    'bottom' => '0',
                    'left' => '20',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'header_section_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [ 'separate_styling_enabled' => 'yes' ],
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'header_section_brdr_',
                'condition' => [ 'separate_styling_enabled' => 'yes' ],
                'selector' => '{{WRAPPER}} .pricing__header',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'header_section_bg',
                'condition' => [ 'separate_styling_enabled' => 'yes' ],
                'fields_options' => [
                    'color' => [ 'label' => esc_html__( 'Background Color', 'bili-core' ) ],
                    'image' => [ 'label' => esc_html__( 'Background Image', 'bili-core' ) ],
                ],
                'selector' => '{{WRAPPER}} .pricing__header',
            ]
        );

        $this->add_control(
            'сontent_section_heading',
            [
                'label' => esc_html__( 'Content Section', 'bili-core' ),
                'type' => Controls_Manager::HEADING,
                'condition' => [ 'separate_styling_enabled' => 'yes' ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'сontent_section_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [ 'separate_styling_enabled' => 'yes' ],
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '30',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '50',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'mobile_default' => [
                    'top' => '30',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '20',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'сontent_section_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [ 'separate_styling_enabled' => 'yes' ],
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '43',
                    'right' => '48',
                    'bottom' => '23',
                    'left' => '0',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
	            'mobile_default' => [
		            'top' => '16',
		            'right' => '0',
		            'bottom' => '20',
		            'left' => '0',
		            'unit'  => 'px',
		            'isLinked' => false
	            ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'content_section_brdr_',
                'condition' => [ 'separate_styling_enabled' => 'yes' ],
                'fields_options' => [
                    'width' => [ 'label' => esc_html__( 'Border Width', 'bili-core' ) ],
                    'color' => [ 'label' => esc_html__( 'Border Color', 'bili-core' ) ],
                ],
                'selector' => '{{WRAPPER}} .pricing__content',
            ]
        );

        $this->add_control(
            'сontent_section_bg',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [ 'separate_styling_enabled' => 'yes' ],
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__content' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_section_heading',
            [
                'label' => esc_html__( 'Button Section', 'bili-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [ 'separate_styling_enabled' => 'yes' ],
            ]
        );

        $this->add_responsive_control(
            'button_section_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [ 'separate_styling_enabled' => 'yes' ],
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '0',
                    'right' => '48',
                    'bottom' => '0',
                    'left' => '48',
	                'unit'  => 'px',
	                'isLinked' => false

                ],
                'mobile_default' => [
                    'top' => '0',
                    'right' => '20',
                    'bottom' => '0',
                    'left' => '20',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_section_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [ 'separate_styling_enabled' => 'yes' ],
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_section_bg',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [ 'separate_styling_enabled' => 'yes' ],
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

	    /** STYLE -> PRETITLE */

	    $this->start_controls_section(
		    'style_pretitle',
		    [
			    'label' => esc_html__( 'Pretitle', 'bili-core' ),
			    'tab' => Controls_Manager::TAB_STYLE,
			    'condition' => [ 'pretitle_text!' => '' ],
		    ]
	    );

	    $this->add_group_control(
		    Group_Control_Typography::get_type(),
		    [
			    'name' => 'pretitle_typography',
			    'selector' => '{{WRAPPER}} .pretitle',
		    ]
	    );

	    $this->add_responsive_control(
		    'pretitle_margin',
		    [
			    'label' => esc_html__( 'Margin', 'bili-core' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', 'em', '%' ],
			    'default' => [
				    'top' => '0',
				    'right' => '0',
				    'bottom' => '10',
				    'left' => '50',
				    'unit'  => 'px',
				    'isLinked' => false
			    ],
			    'mobile_default' => [
				    'top' => '0',
				    'right' => '0',
				    'bottom' => '8',
				    'left' => '20',
				    'unit'  => 'px',
				    'isLinked' => false
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .pricing__pretitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_responsive_control(
		    'pretitle_padding',
		    [
			    'label' => esc_html__( 'Padding', 'bili-core' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', 'em', '%' ],
			    'selectors' => [
				    '{{WRAPPER}} .pricing__pretitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_group_control(
		    Group_Control_Border::get_type(),
		    [
			    'name' => 'pretitle_border',
			    'fields_options' => [
				    'width' => [ 'label' => esc_html__( 'Border Width', 'bili-core' ) ],
				    'color' => [ 'type' => Controls_Manager::HIDDEN],
			    ],
			    'selector' => '{{WRAPPER}} .pricing__pretitle',
		    ]
	    );

	    $this->add_control(
		    'pretitle_radius',
		    [
			    'label' => esc_html__( 'Border Radius', 'bili-core' ),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => [ 'px', 'em', '%' ],
			    'selectors' => [
				    '{{WRAPPER}} .pricing__pretitle' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->start_controls_tabs( 'pretitle' );

	    $this->start_controls_tab(
		    'pretitle_idle',
		    [ 'label' => esc_html__( 'Idle', 'bili-core' ) ]
	    );

	    $this->add_control(
		    'pretitle_color_idle',
		    [
			    'label' => esc_html__( 'Text Color', 'bili-core' ),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => [ 'active' => true ],
			    'default' => '#888888',
			    'selectors' => [
				    '{{WRAPPER}} .pretitle' => 'color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'pretitle_border_color_idle',
		    [
			    'label' => esc_html__( 'Border Color', 'bili-core' ),
			    'type' => Controls_Manager::COLOR,
			    'condition' => [ 'pretitle_border_border!' => '' ],
			    'dynamic' => [ 'active' => true ],
			    'selectors' => [
				    '{{WRAPPER}} .pricing__pretitle' => 'border-color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'pretitle_bg_idle',
		    [
			    'label' => esc_html__( 'Background Color', 'bili-core' ),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => [ 'active' => true ],
			    'default' => '#ffffff',
			    'selectors' => [
				    '{{WRAPPER}} .pretitle::before' => 'background: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->end_controls_tab();

	    $this->start_controls_tab(
		    'pretitle_hover',
		    [ 'label' => esc_html__( 'Hover', 'bili-core' ) ]
	    );

	    $this->add_control(
		    'pretitle_color_hover',
		    [
			    'label' => esc_html__( 'Text Color', 'bili-core' ),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => [ 'active' => true ],
			    'selectors' => [
				    '{{WRAPPER}} .pricing__wrapper:hover .pretitle' => 'color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'pretitle_border_color_hover',
		    [
			    'label' => esc_html__( 'Border Color', 'bili-core' ),
			    'type' => Controls_Manager::COLOR,
			    'condition' => [ 'pretitle_border_border!' => '' ],
			    'dynamic' => [ 'active' => true ],
			    'selectors' => [
				    '{{WRAPPER}} .pricing__wrapper:hover .pricing__pretitle' => 'border-color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'pretitle_bg_hover',
		    [
			    'label' => esc_html__( 'Background Color', 'bili-core' ),
			    'type' => Controls_Manager::COLOR,
			    'dynamic' => [ 'active' => true ],
			    'selectors' => [
				    '{{WRAPPER}} .pricing__wrapper:hover .pricing__pretitle' => 'background-color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->end_controls_tab();
	    $this->end_controls_tabs();

	    $this->add_group_control(
		    Group_Control_Box_Shadow::get_type(),
		    [
			    'name' => 'pretitle_shadow',
			    'separator' => 'before',
			    'selector' => '{{WRAPPER}} .pricing__pretitle',
		    ]
	    );

	    $this->end_controls_section();

        /** STYLE -> TITLE */

        $this->start_controls_section(
            'style_title',
            [
                'label' => esc_html__( 'Title', 'bili-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
	            'condition' => [ 'title_text!' => '' ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .title',
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
	            'default' => [
		            'top' => '0',
		            'right' => '0',
		            'bottom' => '0',
		            'left' => '48',
		            'unit'  => 'px',
		            'isLinked' => false
	            ],
	            'mobile_default' => [
		            'top' => '0',
		            'right' => '0',
		            'bottom' => '0',
		            'left' => '20',
		            'unit'  => 'px',
		            'isLinked' => false
	            ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'title_border',
                'fields_options' => [
                    'width' => [ 'label' => esc_html__( 'Border Width', 'bili-core' ) ],
                    'color' => [ 'type' => Controls_Manager::HIDDEN],
                ],
                'selector' => '{{WRAPPER}} .pricing__title',
            ]
        );

        $this->add_control(
            'title_radius',
            [
                'label' => esc_html__( 'Border Radius', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'title' );

        $this->start_controls_tab(
            'title_idle',
            [ 'label' => esc_html__( 'Idle', 'bili-core' ) ]
        );

        $this->add_control(
            'title_color_idle',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
	            'default' => '#888888',
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_border_color_idle',
            [
                'label' => esc_html__( 'Border Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [ 'title_border_border!' => '' ],
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__title' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_bg_idle',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__title' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_hover',
            [ 'label' => esc_html__( 'Hover', 'bili-core' ) ]
        );

        $this->add_control(
            'title_color_hover',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__wrapper:hover .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_border_color_hover',
            [
                'label' => esc_html__( 'Border Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [ 'title_border_border!' => '' ],
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__wrapper:hover .pricing__title' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_bg_hover',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__wrapper:hover .pricing__title' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'title_shadow',
                'separator' => 'before',
                'selector' => '{{WRAPPER}} .pricing__title',
            ]
        );

        $this->end_controls_section();

        /** STYLE -> TITLE SUFFIX */

        $this->start_controls_section(
            'style_title_suffix',
            [
                'label' => esc_html__( 'Title Suffix', 'bili-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                	'title_suffix_enabled' => 'yes',
                	'title_suffix_text!' => ''
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_suffix_typography',
                'selector' => '{{WRAPPER}} .title__suffix',
            ]
        );

        $this->add_responsive_control(
            'title_suffix_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'allowed_dimensions' => 'horizontal',
                'selectors' => [
                    '{{WRAPPER}} .title__suffix' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_suffix_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .title__suffix' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'title_suffix',
            [ 'separator' => 'before' ]
        );

        $this->start_controls_tab(
            'title_suffix_idle',
            [ 'label' => esc_html__( 'Idle', 'bili-core' ) ]
        );

        $this->add_control(
            'title_suffix_color_idle',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .title__suffix' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_suffix_bg_idle',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .title__suffix' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_suffix_hover',
            [ 'label' => esc_html__( 'Hover', 'bili-core' ) ]
        );

        $this->add_control(
            'title_suffix_color_hover',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
	            'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .pricing__wrapper:hover .title__suffix' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_suffix_bg_hover',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__wrapper:hover .title__suffix' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /** STYLE -> PRICE */

        $this->start_controls_section(
            'style_price',
            [
                'label' => esc_html__( 'Price', 'bili-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
	            'condition' => [ 'price_text!' => '' ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'price_typography',
                'selector' => '{{WRAPPER}} .pricing__price',
            ]
        );

        $this->add_responsive_control(
            'price_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '0',
                    'right' => '-3',
                    'bottom'=> '0',
                    'left' => '0',
	                'unit'  => 'px',
	                'isLinked' => false

                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'price_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'price_radius',
            [
                'label' => esc_html__( 'Border Radius', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__price' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'price_color',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
	            'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .pricing__price' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'price_bg',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__price' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /** STYLE -> PAYMENT CURRENCY */

        $this->start_controls_section(
            'style_currency',
            [
                'label' => esc_html__( 'Payment Currency', 'bili-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
	            'condition' => [ 'currency_text!' => '' ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'currency_typography',
                'selector' => '{{WRAPPER}} .price__currency',
            ]
        );

        $this->add_responsive_control(
            'currency_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => 'horizontal',
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .price__currency' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'currency_color',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .price__currency' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /** STYLE -> PAYMENT PERIOD */

        $this->start_controls_section(
            'style_period',
            [
                'label' => esc_html__( 'Payment Period', 'bili-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
	            'condition' => [ 'period_text!' => '' ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'period_typography',
                'fields_options' => [
                    'typography' => [
                        'default' => 'yes',
                    ],
                    'font_size' => [
                        'default' => [ 'size' => 16, 'unit' => 'px' ]
                    ],
                    'line_height' => [
                        'default' => [ 'size' => 1.5, 'unit' => 'em' ]
                    ],
                    'font_weight' => [
                        'default' => 500,
                    ],
                ],
                'selector' => '{{WRAPPER}} .price__period',
            ]
        );

        $this->add_control(
            'period_display_block',
            [
                'label' => esc_html__( 'Full Width Element', 'bili-core' ),
                'type' => Controls_Manager::SWITCHER,
                'selectors' => [
                    '{{WRAPPER}} .price__period' => 'display: block; position: static;',
                ],
            ]
        );

        $this->add_responsive_control(
            'period_max_width',
            [
                'label' => esc_html__( 'Max Width', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [ 'min' => 0, 'max' => 850 ],
                ],
                'default' => [ 'size' => 70, 'unit' => 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .price__period' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'period_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '-1',
                    'right' => '0',
                    'bottom'=> '0',
                    'left' => '4',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .price__period' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                                                  . 'top: {{TOP}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'period_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .price__period' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'period_radius',
            [
                'label' => esc_html__( 'Border Radius', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .price__period' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'period_color',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
	            'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .price__period' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'period_bg',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .price__period' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /** STYLE -> CONTENT */

        $this->start_controls_section(
            'style_content',
            [
                'label' => esc_html__( 'Content', 'bili-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
	            'condition' => [ 'content_wysiwyg!' => '' ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'fields_options' => [
                    'typography' => [
                        'default' => 'yes',
                    ],
                    'font_weight' => [
                        'default' => 400,
                    ],
                ],
                'selector' => '{{WRAPPER}} .pricing__content',
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
	            'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .pricing__content' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [ 'separate_styling_enabled' => '' ],
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '23',
                    'right' => '0',
                    'bottom'=> '15',
                    'left' => '0',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'content_border',
                'fields_options' => [
                    'border' => [
                        'default' => 'solid',
                    ],
                    'width' => [
                        'label' => esc_html__( 'Border Width', 'bili-core' ),
                        'default' => [
                            'top' => 1,
                            'right' => 0,
                            'bottom' => 0,
                            'left' => 0,
                        ],
                    ],
                    'color' => [ 'default' => WGL_Globals::get_h_font_color( 0.3 ), ],
                ],
                'selector' => '{{WRAPPER}} .pricing__content',
            ]
        );

        $this->end_controls_section();

        /** STYLE -> BUTTON */

        $this->start_controls_section(
            'style_button',
            [
                'label' => esc_html__( 'Button', 'bili-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'button_enabled' => 'yes' ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .wgl-button',
            ]
        );

        $this->add_responsive_control(
            'button_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '16',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '0',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
	            'default' => [
		            'top' => '23',
		            'right' => '79',
		            'bottom'=> '23',
		            'left' => '79',
		            'unit'  => 'px',
		            'isLinked' => false
	            ],
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

	    $this->add_group_control(
		    Group_Control_Border::get_type(),
		    [
			    'name' => 'button_border',
			    'fields_options' => [
				    'color' => [ 'type' => Controls_Manager::HIDDEN ],
				    'border' => [ 'default' => 'solid' ],
				    'width' => [
					    'default' => [
						    'top' => '1',
						    'right' => '1',
						    'bottom' => '1',
						    'left' => '1',
					    ],
					    'label' => esc_html__( 'Border Width', 'bili-core' )
				    ],
			    ],
			    'selector' => '{{WRAPPER}} .wgl-button',
		    ]
	    );

        $this->add_control(
            'button_radius',
            [
                'label' => esc_html__( 'Border Radius', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => 30,
                    'right' => 30,
                    'bottom' => 30,
                    'left' => 30,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'button' );

        $this->start_controls_tab(
            'button_idle',
            [ 'label' => esc_html__( 'Idle', 'bili-core' ) ]
        );

        $this->add_control(
            'button_color_idle',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
	            'default' => WGL_Globals::get_btn_color_idle(),
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_idle',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
	            'default' => WGL_Globals::get_btn_color_idle(0.1),
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_border_color_idle',
            [
                'label' => esc_html__( 'Border Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [ 'button_border_border!' => '' ],
                'dynamic' => [ 'active' => true ],
	            'default' => WGL_Globals::get_btn_bg_hover(),
                'selectors' => [
                    '{{WRAPPER}} .wgl-button' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_shadow_idle',
                'selector' => '{{WRAPPER}} .wgl-button',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_hover',
            [ 'label' => esc_html__( 'Hover', 'bili-core' ) ]
        );

        $this->add_control(
            'button_color_hover',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
	            'default' => WGL_Globals::get_btn_color_hover(),
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:hover,
                     {{WRAPPER}} .wgl-button:focus' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_hover',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
	            'default' => WGL_Globals::get_btn_bg_idle(),
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:hover,
                     {{WRAPPER}} .wgl-button:focus' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_border_color_hover',
            [
                'label' => esc_html__( 'Border Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [ 'button_border_border!' => '' ],
                'dynamic' => [ 'active' => true ],
	            'default' => WGL_Globals::get_btn_bg_idle(),
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_shadow_hover',
                'selector' => '{{WRAPPER}} .wgl-button:hover'
                            . '{{WRAPPER}} .wgl-button:focus',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_active',
            [ 'label' => esc_html__( 'Active', 'bili-core' ) ]
        );

        $this->add_control(
            'button_color_active',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'default' => WGL_Globals::get_btn_color_hover(),
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_active',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'default' => WGL_Globals::get_btn_bg_idle(),
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:active' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_border_color_active',
            [
                'label' => esc_html__( 'Border Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [ 'border_border!' => '' ],
                'dynamic' => [ 'active' => true ],
                'default' => WGL_Globals::get_btn_bg_idle(),
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:active' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_shadow_active',
                'selector' => '{{WRAPPER}} .wgl-button:active',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'btn_media_heading',
            [
                'label' => esc_html__( 'Button Media (icon/image)', 'bili-core' ),
                'type' => Controls_Manager::HEADING,
                'condition' => [ 'icon_type!' => '' ],
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_icon_typography',
                'condition' => [ 'icon_type' => 'font' ],
                'exclude' => [ 'font_family', 'text_transform', 'font_style', 'text_decoration', 'letter_spacing' ],
	            'fields_options' => [
		            'typography' => [
			            'default' => 'yes',
		            ],
		            'font_size' => [
			            'default' => [ 'size' => '21', 'unit' => 'px' ]
		            ],
	            ],
                'selector' => '{{WRAPPER}} .elementor-icon',
            ]
        );

        $this->add_responsive_control(
            'media_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [ 'icon_type!' => '' ],
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .media-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_rotation',
            [
                'label' => esc_html__( 'Rotation', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'condition' => [ 'icon_type' => 'font' ],
                'size_units' => [ 'deg', 'turn' ],
                'range' => [
                    'px' => [ 'max' => 360 ],
                    'turn' => [ 'max' => 1, 'step' => 0.05 ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-icon' => 'transform: rotate({{SIZE}}{{UNIT}});',
                ],
            ]
        );

        $this->start_controls_tabs(
            'tabs_icon',
            [
                'condition' => [ 'icon_type' => 'font' ],
            ]
        );

        $this->start_controls_tab(
            'icon_idle',
            [ 'label' => esc_html__( 'Idle', 'bili-core' ) ]
        );

        $this->add_control(
            'icon_color_idle',
            [
                'label' => esc_html__( 'Icon Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
	            'default' => WGL_Globals::get_btn_bg_hover(),
                'selectors' => [
                    '{{WRAPPER}} .elementor-icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'icon_hover',
            [ 'label' => esc_html__( 'Hover', 'bili-core' ) ]
        );

        $this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__( 'Icon Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
	            'default' => WGL_Globals::get_btn_color_hover(),
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:hover .elementor-icon,
                     {{WRAPPER}} .wgl-button:focus .elementor-icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'icon_active',
            [ 'label' => esc_html__( 'Active', 'bili-core' ) ]
        );

        $this->add_control(
            'icon_color_active',
            [
                'label' => esc_html__( 'Icon Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-button:active .elementor-icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /** STYLE -> DESCRIPTION */

        $this->start_controls_section(
            'style_description',
            [
                'label' => esc_html__( 'Description', 'bili-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'description_text!' => '' ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'fields_options' => [
                    'typography' => [
                        'default' => 'yes',
                    ],
                    'text_decoration' => [
                        'default' => 'underline',
                    ],
                ],
                'selector' => '{{WRAPPER}} .pricing__description',
            ]
        );

        $this->add_responsive_control(
            'description_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '10',
                    'right' => '0',
                    'bottom'=> '0',
                    'left' => '0',
	                'unit'  => 'px',
	                'isLinked' => false
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'description_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'description' );

        $this->start_controls_tab(
            'description_idle',
            [ 'label' => esc_html__( 'Idle', 'bili-core' ) ]
        );

        $this->add_control(
            'description_color_idle',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
	            'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .pricing__description' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'description_hover',
            [ 'label' => esc_html__( 'Hover', 'bili-core' ) ]
        );

        $this->add_control(
            'description_color_hover',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .pricing__description:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function render()
    {
        $wrapper_classes = $this->get_settings_for_display( 'hover_animation' ) ? ' hover-animation' : '';

        echo '<div class="wgl-pricing_plan', $wrapper_classes, '">',
            '<div class="pricing__wrapper">',
                '<div class="pricing__pretitle">',
                    $this->get_pricing_pretitle(),
                '</div>',
                '<div class="pricing__title">',
                    $this->get_pricing_title(),
                '</div>',
                '<div class="pricing__header">',
                    '<div class="pricing__price">',
                        $this->get_currency(),
                        $this->get_price_value(),
                        $this->get_period(),
                    '</div>',
                '</div>',
                '<div class="pricing__content">',
                    $this->get_settings_for_display( 'content_wysiwyg' ),
                '</div>',
                '<div class="pricing__button">',
                    $this->get_button(),
                    $this->get_description(),
                '</div>',
            '</div>',
        '</div>';
    }

    protected function get_pricing_title()
    {
        $title = $this->get_settings_for_display( 'title_text' );
        $suffix = $this->get_settings_for_display( 'title_suffix_text' );

        if ( ! $title && ! $suffix ) {
            // Bailout.
            return;
        }

        $suffix = $suffix ? '<span class="title__suffix">' . $suffix  . '</span>' : '';

        return '<h4 class="title">'
                . wp_kses( $title, self::get_kses_allowed_html() )
                . $suffix
            . '</h4>';
    }

    protected function get_pricing_pretitle()
    {
        $pretitle = $this->get_settings_for_display( 'pretitle_text' );

        if ( ! $pretitle ) {
            // Bailout.
            return;
        }

        return '<h6 class="pretitle">'
                . wp_kses( $pretitle, self::get_kses_allowed_html() )
            . '</h6>';
    }

    protected function get_currency()
    {
        $currency = $this->get_settings_for_display( 'currency_text' );

        if ( ! $currency ) {
            // Bailout.
            return;
        }

        return '<span class="price__currency">'
                . esc_html( $currency )
            . '</span>';
    }

    protected function get_period()
    {
        $period = $this->get_settings_for_display( 'period_text' );

        if ( ! $period ) {
            // Bailout.
            return;
        }

        return '<span class="price__period">'
                . esc_html( $period )
            . '</span>';
    }

    protected function get_description()
    {
        $description = $this->get_settings_for_display( 'description_text' );

        if ( ! $description ) {
            // Bailout.
            return;
        }

        return '<div class="pricing__description">'
                . wp_kses( trim( $description ), self::get_kses_allowed_html() )
            . '</div>';
    }

    protected function get_price_value()
    {
        $price = $this->get_settings_for_display( 'price_text' );

        if ( ! $price ) {
            // Bailout.
            return;
        }

        $price = esc_html( $price );

        preg_match( '/(.+)(\.| |,)(\d+)$/', $price, $matches, PREG_OFFSET_CAPTURE );
        if ( isset( $matches[ 0 ] ) ) {
            $price = esc_html( $matches[ 1 ][ 0 ] )
                . '<span class="price_decimal">'
                    . esc_html( $matches[ 3 ][ 0 ] )
                . '</span>';
        }

        return '<span class="price__value">'
                . $price
            . '</span>';
    }

    protected function get_button()
    {
        $button_disabled = ! $this->get_settings_for_display( 'button_enabled' );

        if ( $button_disabled ) {
            // Bailout.
            return;
        }

        $button_options = [
            'size' => 'xl',
            'text' => $this->get_settings_for_display( 'button_text' ),
            'link' => $this->get_settings_for_display( 'button_link' ),
            // Media
            'icon_type' => $this->get_settings_for_display( 'icon_type' ),
            'icon_fontawesome' => $this->get_settings_for_display( 'icon_fontawesome' ),
            'icon_align' => $this->get_settings_for_display( 'icon_align' ),
            'thumbnail' => $this->get_settings_for_display( 'thumbnail' ),
            'img_size_string' => $this->get_settings_for_display( 'img_size_string' ),
            'img_size_array' => $this->get_settings_for_display( 'img_size_array' ),
            'img_aspect_ratio' => $this->get_settings_for_display( 'img_aspect_ratio' ),
        ];

        ob_start();
            ( new WGL_Button() )->render( $this, $button_options );

        return ob_get_clean();
    }

    protected static function get_kses_allowed_html()
    {
        $allowed_attributes = [
            'id' => true,
            'class' => true,
            'style' => true,
        ];

        return [
            'a' => $allowed_attributes + [
                'href' => true,
                'title' => true,
                'rel' => true,
                'target' => true,
            ],
            'br' => $allowed_attributes,
            'b' => $allowed_attributes,
            'strong' => $allowed_attributes,
            'em' => $allowed_attributes,
            'i' => $allowed_attributes,
            'small' => $allowed_attributes,
            'sup' => $allowed_attributes,
            'sub' => $allowed_attributes,
            'span' => $allowed_attributes,
            'p' => $allowed_attributes,
            'ul' => $allowed_attributes,
            'ol' => $allowed_attributes,
            'li' => $allowed_attributes,
        ];
    }

    public function wpml_support_module()
    {
        add_filter( 'wpml_elementor_widgets_to_translate',  [ $this, 'wpml_widgets_to_translate_filter' ] );
    }

    public function wpml_widgets_to_translate_filter( $widgets )
    {
        return \WGL_Extensions\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }
}
